```toml
[advisory]
id = "RUSTSEC-2020-0080"
package = "miow"
aliases = ["CVE-2020-35921", "GHSA-jrcf-4jp8-m28v"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-11-13"
url = "https://github.com/yoshuawuyts/miow/issues/38"
keywords = ["memory", "layout", "cast"]
informational = "unsound"

[versions]
patched = ["^ 0.2.2", ">= 0.3.6"]
```

# `miow` invalidly assumes the memory layout of std::net::SocketAddr

The [`miow`](https://crates.io/crates/miow) crate has assumed `std::net::SocketAddrV4`
and `std::net::SocketAddrV6` have the same memory layout as the system C representation
`sockaddr`. It has simply casted the pointers to convert the socket addresses to the
system representation. The standard library does not say anything about the memory
layout, and this will cause invalid memory access if the standard library
changes the implementation. No warnings or errors will be emitted once the
change happens.
