```toml
[advisory]
id = "RUSTSEC-2020-0081"
package = "mio"
aliases = ["CVE-2020-35922", "GHSA-pf3p-x6qj-6j7q"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-11-02"
url = "https://github.com/tokio-rs/mio/issues/1386"
keywords = ["memory", "layout", "cast"]
informational = "unsound"

[versions]
patched = [">= 0.7.6"]
unaffected = ["< 0.7.0"]
```

# `mio` invalidly assumes the memory layout of std::net::SocketAddr

The [`mio`](https://crates.io/crates/mio) crate has assumed `std::net::SocketAddrV4`
and `std::net::SocketAddrV6` have the same memory layout as the system C representation
`sockaddr`. It has simply casted the pointers to convert the socket addresses to the
system representation. The standard library does not say anything about the memory
layout, and this will cause invalid memory access if the standard library
changes the implementation. No warnings or errors will be emitted once the
change happens.
