```toml
[advisory]
id = "RUSTSEC-2021-0113"
package = "metrics-util"
date = "2021-04-07"
url = "https://github.com/metrics-rs/metrics/issues/190"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2021-45704", "GHSA-3hxh-7jxm-59x4", "GHSA-cwvc-87xq-pc5m"]
[versions]
patched = [">= 0.7.0"]
```

# AtomicBucket<T> unconditionally implements Send/Sync

In the affected versions of the crate, `AtomicBucket<T>` unconditionally implements `Send`/`Sync` traits. Therefore, users can create a data race to the inner
`T: !Sync` by using the `AtomicBucket::data_with()` API.
Such data races can potentially cause memory corruption or other undefined behavior.

The flaw was fixed in commit 8e6daab by adding appropriate Send/Sync bounds to the Send/Sync impl of struct `Block<T>` (which is a data type contained inside `AtomicBucket<T>`).
