```toml
[advisory]
id = "RUSTSEC-2024-0434"
package = "matrix-sdk-crypto"
date = "2024-01-07"
url = "https://github.com/matrix-org/matrix-rust-sdk/security/advisories/GHSA-r5vf-wf4h-82gg"
categories = ["crypto-failure"]
aliases = ["CVE-2024-52813", "GHSA-r5vf-wf4h-82gg"]
informational = "notice"

[versions]
patched = [">= 0.8.0"]
```

#  Missing facility to signal rotation of a verified cryptographic identity

Versions of the matrix-sdk-crypto Rust crate before 0.8.0 lack a dedicated
mechanism to notify that a user's cryptographic identity has changed from a
verified to an unverified one, which could cause client applications relying on
the SDK to overlook such changes.

matrix-sdk-crypto 0.8.0 adds a new `VerificationLevel::VerificationViolation`
enum variant which indicates that a previously verified identity has been
changed.
