```toml
[advisory]
id = "RUSTSEC-2019-0021"
package = "linea"
aliases = ["CVE-2019-16880", "GHSA-j52m-489x-v634"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["memory-corruption"]
date = "2019-09-14"
keywords = ["double free"]
url = "https://github.com/strake/linea.rs/issues/2"

[versions]
patched = ["> 0.9.4"]
```

# `Matrix::zip_elements` causes double free

Affected versions of this crate did not properly implements the `Matrix::zip_elements` method, which causes an double free when the given trait implementation might panic.

This allows an attacker to corrupt or take control of the memory.
 
The flaw was corrected by Phosphorus15.
