```toml
[advisory]
id = "RUSTSEC-2023-0055"
package = "lexical"
date = "2023-09-03"
informational = "unsound"
references = ["https://github.com/Alexhuszagh/rust-lexical/issues/102", "https://github.com/Alexhuszagh/rust-lexical/issues/101", "https://github.com/Alexhuszagh/rust-lexical/issues/95", "https://github.com/Alexhuszagh/rust-lexical/issues/104", "https://github.com/Alexhuszagh/rust-lexical/issues/126"]
aliases = ["GHSA-c2hm-mjxv-89r4"]

[versions]
patched = [">= 7.0.0"]
```

# Multiple soundness issues

`lexical` contains multiple soundness issues:

 1. [Bytes::read() allows creating instances of types with invalid bit patterns](https://github.com/Alexhuszagh/rust-lexical/issues/102)
 1. [BytesIter::read() advances iterators out of bounds](https://github.com/Alexhuszagh/rust-lexical/issues/101)
 1. [The `BytesIter` trait has safety invariants but is public and not marked `unsafe`](https://github.com/Alexhuszagh/rust-lexical/issues/104)
 1. [`write_float()` calls `MaybeUninit::assume_init()` on uninitialized data, which is is not allowed by the Rust abstract machine](https://github.com/Alexhuszagh/rust-lexical/issues/95)
 1. [`radix()` calls `MaybeUninit::assume_init()` on uninitialized data, which is is not allowed by the Rust abstract machine](https://github.com/Alexhuszagh/rust-lexical/issues/126)

The crate also has some correctness issues.

## Alternatives

For quickly parsing floating-point numbers third-party crates are no longer needed. A fast float parsing algorithm by the author of `lexical` has been [merged](https://github.com/rust-lang/rust/pull/86761) into libcore.

For quickly parsing integers, consider `atoi` and `btoi` crates (100% safe code). `atoi_radix10` provides even faster parsing, but only with `-C target-cpu=native`, and at the cost of some `unsafe`.

For formatting integers in a `#[no_std]` context consider the [`numtoa`](https://crates.io/crates/numtoa) crate.

For working with big numbers consider `num-bigint` and `num-traits`.
