```toml
[advisory]
id = "RUSTSEC-2021-0036"
package = "internment"
aliases = ["CVE-2021-28037", "GHSA-gppw-3h6h-v6q2"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-03-03"
url = "https://github.com/droundy/internment/issues/20"
categories = ["thread-safety"]

[versions]
patched = [">= 0.4.2"]
```

# Intern<T>: Data race allowed on T

Affected versions of this crate unconditionally implements `Sync` for `Intern<T>`.
This allows users to create data race on `T: !Sync`, which may lead to undefined behavior
(for example, memory corruption).

The flaw was corrected in commit 2928a87 by adding the trait bound `T: Sync` in the `Sync` impl of `Intern<T>`.
