```toml
[advisory]
id = "RUSTSEC-2020-0096"
package = "im"
aliases = ["CVE-2020-36204", "GHSA-q9h2-4xhf-23xx"]
cvss = "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-11-09"
url = "https://github.com/bodil/im-rs/issues/157"
categories = ["thread-safety"]
informational = "unsound"

[versions]
patched = [">= 15.1.0"]
unaffected = ["< 12.0.0"]
```

# TreeFocus lacks bounds on its Send and Sync traits

Affected versions of `im` contains `TreeFocus` that unconditionally implements `Send` and `Sync`.

This allows a data race in safe Rust code if `TreeFocus` is extracted from `Focus` type.
Typical users that only use `Focus` type are not affected.
