```toml
[advisory]
id = "RUSTSEC-2022-0022"
package = "hyper"
date = "2022-05-10"
informational = "unsound"
url = "https://github.com/hyperium/hyper/pull/2545"
aliases = ["GHSA-f67m-9j94-qv9j"]

[versions]
patched = [">= 0.14.12"]
```

# Parser creates invalid uninitialized value

Affected versions of this crate called `mem::uninitialized()` in the HTTP1 parser to create values of type `httparse::Header` (from the `httparse` crate).
This is unsound, since `Header` contains references and thus must be non-null.
 
The flaw was corrected by avoiding the use of `mem::uninitialized()`, using `MaybeUninit` instead.
