```toml
[advisory]
id = "RUSTSEC-2021-0078"
package = "hyper"
date = "2021-07-07"
url = "https://github.com/hyperium/hyper/security/advisories/GHSA-f3pg-qwvg-p99c"
keywords = ["parsing", "http"]
aliases = ["CVE-2021-32715", "GHSA-f3pg-qwvg-p99c"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N"

[versions]
patched = [">= 0.14.10"]
```

# Lenient `hyper` header parsing of `Content-Length` could allow request smuggling

`hyper`'s HTTP header parser accepted, according to RFC 7230, illegal contents inside `Content-Length` headers.
Due to this, upstream HTTP proxies that ignore the header may still forward them along if it chooses to ignore the error.

To be vulnerable, `hyper` must be used as an HTTP/1 server and using an HTTP proxy upstream that ignores the header's contents
but still forwards it. Due to all the factors that must line up, an attack exploiting this vulnerability is unlikely.
