```toml
[advisory]
id = "RUSTSEC-2022-0072"
package = "hyper-staticfile"
date = "2022-12-23"
url = "https://github.com/stephank/hyper-staticfile/commit/f12cadc6666c6f555d29725f5bc45da2103f24ea"
categories = ["format-injection"]
keywords = ["open redirect", "http"]
aliases = ["GHSA-5wvv-q5fv-2388"]

[versions]
patched = ["^0.9.4", ">= 0.10.0-alpha.5"]
```

# Location header incorporates user input, allowing open redirect

When `hyper-staticfile` performs a redirect for a directory request (e.g. a
request for `/dir` that redirects to `/dir/`), the `Location` header value was
derived from user input (the request path), simply appending a slash. The
intent was to perform an origin-relative redirect, but specific inputs
allowed performing a scheme-relative redirect instead.

An attacker could craft a special URL that would appear to be for the correct
domain, but immediately redirects to a malicious domain. Such a URL can benefit
phishing attacks, for example an innocent looking link in an email.
