```toml
[advisory]
id = "RUSTSEC-2019-0033"
package = "http"
aliases = ["CVE-2019-25008", "CVE-2020-25574", "GHSA-x7vr-c387-8w57", "GHSA-xvc9-xwgj-4cq9"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["denial-of-service"]
date = "2019-11-16"
keywords = ["http", "integer-overflow", "DoS"]
url = "https://github.com/hyperium/http/issues/352"

[affected.functions]
"http::header::HeaderMap::reserve" = ["< 0.1.20"]

[versions]
patched = [">= 0.1.20"]
```

# Integer Overflow in HeaderMap::reserve() can cause Denial of Service

`HeaderMap::reserve()` used `usize::next_power_of_two()` to calculate the increased capacity.
However, `next_power_of_two()` silently overflows to 0 if given a sufficiently large number
in release mode.

If the map was not empty when the overflow happens,
the library will invoke `self.grow(0)` and start infinite probing.
This allows an attacker who controls the argument to `reserve()`
to cause a potential denial of service (DoS).

The flaw was corrected in 0.1.20 release of `http` crate.
