```toml
[advisory]
id = "RUSTSEC-2023-0085"
package = "hpack"
date = "2023-09-15"
url = "https://github.com/mlalic/hpack-rs/issues/11"
categories = ["denial-of-service"]
references = ["https://github.com/sno2/hpack-rs-patched/commit/d669282924a95311599e9e7dd53869ee96b3a2f5"]
aliases = ["GHSA-w7hm-hmxv-pvhf"]

[versions]
patched = []
```

# HPACK decoder panics on invalid input

Due to insufficient checking of input data, decoding certain data sequences can
lead to _Decoder::decode_ panicking rather than returning an error.

Example code that triggers this vulnerability looks like this:

```rust
use hpack::Decoder;

pub fn main() {
  let input = &[0x3f];
  let mut decoder = Decoder::new();
  let _ = decoder.decode(input);
}
```

hpack is unmaintained. A crate with the panics fixed has been published as
[hpack-patched](https://crates.io/crates/hpack-patched).

Also consider using [fluke-hpack](https://crates.io/crates/fluke-hpack) or
[httlib-huffman](https://crates.io/crates/httlib-huffman) as an alternative.
