```toml
[advisory]
id = "RUSTSEC-2021-0005"
package = "glsl-layout"
aliases = ["CVE-2021-25902", "GHSA-cx4j-fxr7-jxg8"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2021-01-10"
url = "https://github.com/rustgd/glsl-layout/pull/10"
categories = ["memory-corruption"]

[versions]
patched = [">= 0.4.0"]
```

# Double drop upon panic in 'fn map_array()'

Affected versions of this crate did not guard against panic within the user-provided function `f` (2nd parameter of `fn map_array`), and thus panic within `f` 
causes double drop of a single object.

The flaw was corrected in the 0.4.0 release by wrapping the object vulnerable
to a double drop within `ManuallyDrop<T>`.
