```toml
[advisory]
id = "RUSTSEC-2022-0093"
package = "ed25519-dalek"
date = "2022-06-11"
categories = ["crypto-failure"]
url = "https://github.com/MystenLabs/ed25519-unsafe-libs"
aliases = ["GHSA-w5vr-6qhr-36cc"]

[versions]
patched = [">= 2"]
```

# Double Public Key Signing Function Oracle Attack on `ed25519-dalek`

Versions of `ed25519-dalek` prior to v2.0 model private and public keys as
separate types which can be assembled into a `Keypair`, and also provide APIs
for serializing and deserializing 64-byte private/public keypairs.

Such APIs and serializations are inherently unsafe as the public key is one of
the inputs used in the deterministic computation of the `S` part of the signature,
but not in the `R` value. An adversary could somehow use the signing function as
an oracle that allows arbitrary public keys as input can obtain two signatures
for the same message sharing the same `R` and only differ on the `S` part.

Unfortunately, when this happens, one can easily extract the private key.

Revised public APIs in v2.0 of `ed25519-dalek` do NOT allow a decoupled
private/public keypair as signing input, except as part of specially labeled
"hazmat" APIs which are clearly labeled as being dangerous if misused.
