```toml
[advisory]
id = "RUSTSEC-2022-0002"
package = "dashmap"
date = "2022-01-10"
url = "https://github.com/xacrimon/dashmap/issues/167"
categories = ["memory-exposure", "memory-corruption"]
keywords = ["segfault", "use-after-free"]
aliases = ["GHSA-mpg5-fvwp-42m2"]

[affected.functions]
"dashmap::mapref::multiple::RefMulti::key" = [">= 5.0.0"]
"dashmap::mapref::multiple::RefMulti::value" = [">= 5.0.0"]
"dashmap::mapref::multiple::RefMulti::pair" = [">= 5.0.0"]
"dashmap::mapref::multiple::RefMutMulti::key" = [">= 5.0.0"]
"dashmap::mapref::multiple::RefMutMulti::pair" = [">= 5.0.0"]
"dashmap::mapref::multiple::RefMutMulti::pair_mut" = [">= 5.0.0"]
"dashmap::mapref::one::Ref::key" = [">= 5.0.0"]
"dashmap::mapref::one::Ref::value" = [">= 5.0.0"]
"dashmap::mapref::one::Ref::pair" = [">= 5.0.0"]
"dashmap::mapref::one::RefMut::key" = [">= 5.0.0"]
"dashmap::mapref::one::RefMut::pair" = [">= 5.0.0"]
"dashmap::mapref::one::RefMut::pair_mut" = [">= 5.0.0"]
"dashmap::setref::multiple::RefMulti::key" = [">= 5.0.0"]
"dashmap::setref::one::Ref::key" = [">= 5.0.0"]

[versions]
patched = [">= 5.1.0"]
unaffected = ["< 5.0.0"]
```

# Unsoundness in `dashmap` references

Reference returned by some methods of `Ref` (and similar types) may outlive the `Ref` and escape the lock.
This causes undefined behavior and may result in a segfault.

More information in [`dashmap#167`](https://github.com/xacrimon/dashmap/issues/167) issue.
