```toml
[advisory]
id = "RUSTSEC-2021-0067"
package = "cranelift-codegen"
date = "2021-05-21"
url = "https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-hpqh-2wqx-7qp5"
categories = ["code-execution", "memory-corruption", "memory-exposure"]
keywords = ["miscompile", "sandbox", "wasm"]
aliases = ["CVE-2021-32629", "GHSA-hpqh-2wqx-7qp5"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H"

[versions]
patched = [">= 0.73.1"]

[affected]
arch = ["x86"]
```

# Memory access due to code generation flaw in Cranelift module

There is a bug in 0.73.0 of the Cranelift x64 backend that can create a
scenario that could result in a potential sandbox escape in a WebAssembly
module. Users of versions 0.73.0 of Cranelift should upgrade to either 0.73.1
or 0.74 to remediate this vulnerability. Users of Cranelift prior to 0.73.0
should update to 0.73.1 or 0.74 if they were not using the old default backend.

More details can be found in the GitHub Security Advisory at:

<https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-hpqh-2wqx-7qp5>
