```toml
[advisory]
id = "RUSTSEC-2024-0338"
package = "cosmwasm-std"
date = "2024-04-24"
url = "https://github.com/CosmWasm/advisories/blob/main/CWAs/CWA-2024-002.md"
keywords = ["overflow", "integer", "arithmetic"]
aliases = ["GHSA-8724-5xmm-w5xq"]

[versions]
patched = [">= 1.4.4, < 1.5.0", ">= 1.5.4, < 2.0.0", ">= 2.0.2"]
unaffected = ["< 1.3.0"]
```

# Arithmetic overflows in cosmwasm-std

Some mathematical operations in `cosmwasm-std` use wrapping math instead of
panicking on overflow for very big numbers. This can lead to wrong calculations in contracts
that use these operations.

Affected functions:

- `Uint{256,512}::pow` / `Int{256,512}::pow`
- `Int{256,512}::neg`

Affected if `overflow-checks = true` is not set:

- `Uint{64,128}::pow` / `Int{64,128}::pow`
- `Int{64,128}::neg`
