```toml
[advisory]
id = "RUSTSEC-2020-0117"
package = "conqueue"
date = "2020-11-24"
url = "https://github.com/longshorej/conqueue/issues/9"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36437", "GHSA-368f-29c3-4f2r"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.4.0"]
```

# QueueSender<T>/QueueReceiver<T>: Send/Sync impls need `T: Send`

Affected versions of this crate unconditionally implemented `Send`/`Sync` for `QueueSender<T>`,
allowing to send non-Send `T` to other threads by invoking `(&QueueSender<T>).send()`.

This fails to prevent users from creating data races by sending types like `Rc<T>` or `Arc<Cell<T>>` to other threads, which can lead to memory corruption.

The flaw was corrected in commit 1e462c3 by imposing `T: Send` to both `Send`/`Sync` impls for `QueueSender<T>`/`QueueReceiver<T>`.
