```toml
[advisory]
id = "RUSTSEC-2021-0108"
package = "ckb"
date = "2021-07-25"
url = "https://github.com/nervosnetwork/ckb/security/advisories/GHSA-48vq-8jqv-gm6f"
aliases = ["CVE-2021-45699", "GHSA-2969-8hh9-57jc", "GHSA-48vq-8jqv-gm6f"]
[versions]
patched = [">= 0.40.0"]
```

# Remote memory exhaustion in ckb

In the ckb sync protocol, SyncState maintains a HashMap called 'misbehavior' that keeps a score of a peer's violations of the protocol. This HashMap is keyed to PeerIndex (an alias for SessionId), and entries are never removed from it. SessionId is an integer that increases monotonically with every new connection.

A remote attacker can manipulate this HashMap to grow forever, resulting in degraded performance and ultimately a panic on allocation failure or being killed by the OS, depending on the platform.

This is a critical severity security bug. It could be exploited to create a targeted or network-wide denial of service, to reduce the hash power of the network as part of a 51% attack, and perhaps in other creative ways.
