```toml
[advisory]
id = "RUSTSEC-2020-0112"
package = "buttplug"
aliases = ["CVE-2020-36218", "GHSA-r7rv-2rph-hvhj"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2020-12-18"
url = "https://github.com/buttplugio/buttplug-rs/issues/225"
categories = ["memory-corruption", "thread-safety"]

[versions]
# Versions which include fixes for this vulnerability
patched = [">= 1.0.4"]
```

# ButtplugFutureStateShared allows data race to (!Send|!Sync) objects

`ButtplugFutureStateShared<T>` implements `Send` & `Sync` regardless of `T`.

If `T: !Send` for `ButtplugFutureStateShared<T>`, it is possible to move non-Send types across thread boundaries (e.g. `T`=`Rc<T>`) and lead to undefined behavior.
If `T: !Sync` for `ButtplugFutureStateShared<T>`, it is possible to cause data race to `T` (e.g. `T`=`Arc<Cell<_>>`) and lead to undefined behavior.

The flaw was corrected in version 1.0.4 by removing manual implementations of `Send`/`Sync` for `ButtplugFutureStateShared<T>` to let rustc generate auto trait implementations with correct trait bounds on `T`.
