```toml
[advisory]
id = "RUSTSEC-2023-0033"
package = "borsh"
date = "2023-04-12"
url = "https://github.com/near/borsh-rs/issues/19"
references = ["https://github.com/near/borsh-rs/pull/136"]
informational = "unsound"
categories = ["memory-corruption"]
aliases = ["GHSA-fjx5-qpf4-xjf2"]

[affected]
[versions]
patched = [">= 1.0.0-alpha.1", "^0.10.4"]
```

# Parsing borsh messages with ZST which are not-copy/clone is unsound

Affected versions of borsh cause undefined behavior when zero-sized-types (ZST) 
are parsed and the Copy/Clone traits are not implemented/derived.
For instance if 1000 instances of a ZST are deserialized, and the ZST is not copy 
(this can be achieved through a singleton), then accessing/writing to deserialized 
data will cause a segmentation fault.

There is currently no way for borsh to read data without also providing a Rust type. 
Therefore, if not ZST are used for serialization, then you are not affected by this issue. 
