```toml
[advisory]
id = "RUSTSEC-2020-0007"
package = "bitvec"
aliases = ["CVE-2020-35862", "GHSA-7cjc-hvxf-gqh7"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["memory-corruption"]
date = "2020-03-27"
url = "https://github.com/myrrlyn/bitvec/issues/55"

[affected.functions]
"bitvec::vec::BitVec::into_boxed_bitslice" = ["< 0.17.4, >= 0.11.0"]

[versions]
patched = [">= 0.17.4"]
unaffected = ["< 0.11.0"]
```

# use-after or double free of allocated memory

Conversion of `BitVec` to `BitBox` did not account for allocation movement.

The flaw was corrected by using the address after resizing, rather than the original base address.
