```toml
[advisory]
id = "RUSTSEC-2023-0015"
package = "ascii"
date = "2023-02-25"
url = "https://github.com/tomprogrammer/rust-ascii/issues/64"
informational = "unsound"
categories = ["memory-corruption"]
keywords = ["ascii"]
aliases = ["GHSA-mrrw-grhq-86gf"]
[versions]
patched = [">= 0.9.3"]
unaffected = ["<= 0.6.0"]
```

# Ascii allows out-of-bounds array indexing in safe code

Affected version of this crate had implementation of `From<&mut AsciiStr>` for `&mut [u8]` and `&mut str`. This can result in out-of-bounds array indexing in safe code.

The flaw was corrected in commit [8a6c779](https://github.com/tomprogrammer/rust-ascii/pull/63/commits/8a6c7798c202766bd57d70fb8d12739dd68fb9dc) by removing those impls.
