```toml
[advisory]
id = "RUSTSEC-2022-0003"
package = "ammonia"
date = "2022-01-19"
url = "https://github.com/rust-ammonia/ammonia/pull/147"
categories = ["format-injection"]
keywords = ["html", "xss"]
aliases = ["GHSA-p2g9-94wh-65c2"]

[affected]
functions = { "ammonia::clean_text" = ["<= 3.1.2"] }

[versions]
patched = [">= 3.1.3"]
unaffected = ["< 3.0.0"]
```

# Space bug in `clean_text`

An incorrect mapping from HTML specification to ASCII codes was used.
Because HTML treats the Form Feed as whitespace, code like this has an injection bug:

    let html = format!("<div title={}>", clean_text(user_supplied_string));

Applications are not affected if they quote their attributes, or if they don't use `clean_text` at all.
