```toml
[advisory]
id = "RUSTSEC-2021-0074"
package = "ammonia"
date = "2021-07-08"
url = "https://github.com/rust-ammonia/ammonia/pull/142"
categories = ["format-injection"]
keywords = ["html", "xss"]
aliases = ["CVE-2021-38193", "GHSA-5325-xw5m-phm3"]

[versions]
patched = [">= 3.1.0", ">= 2.1.3, < 3.0.0"]
```

# Incorrect handling of embedded SVG and MathML leads to mutation XSS

Affected versions of this crate did not account for namespace-related parsing
differences between HTML, SVG, and MathML. Even if the `svg` and `math` elements
are not allowed, the underlying HTML parser still treats them differently.
Running cleanup without accounting for these differing namespaces resulted in an "impossible"
DOM, which appeared "safe" when examining the DOM tree, but when serialized and deserialized,
could be exploited to inject arbitrary markup.

To exploit this, the application using this library must allow a tag that is parsed as raw text in HTML.
These [elements] are:

* title
* textarea
* xmp
* iframe
* noembed
* noframes
* plaintext
* noscript
* style
* script

Applications that do not explicitly allow any of these tags should not be affected, since none are allowed by default.

[elements]: https://github.com/servo/html5ever/blob/57eb334c0ffccc6f88d563419f0fbeef6ff5741c/html5ever/src/tree_builder/rules.rs
