```toml
[advisory]
id = "RUSTSEC-2020-0121"
package = "abox"
date = "2020-11-10"
url = "https://github.com/SonicFrog/abox/issues/1"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36441", "GHSA-r626-fc64-3q28"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.4.1"]
```

# AtomicBox<T> implements Send/Sync for any `T: Sized`

Affected versions of this crate implements `Send`/`Sync` for `AtomicBox<T>` without requiring `T: Send`/`T: Sync`. This allows to create data races to `T: !Sync` and send `T: !Send` to another thread.

Such behavior breaks the compile-time thread safety guarantees of Rust, and allows users to incur undefined behavior using safe Rust (e.g. memory corruption from data race).

The flaw was corrected in commit 34c2b9e by adding trait bound `T: Send` to `Send` impl for `AtomicBox<T>` and trait bound `T: Sync` to `Sync` impl for `AtomicBox<T>`.
