// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package timestreaminfluxdbiface provides an interface to enable mocking the Timestream InfluxDB service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package timestreaminfluxdbiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/timestreaminfluxdb"
)

// TimestreamInfluxDBAPI provides an interface to enable mocking the
// timestreaminfluxdb.TimestreamInfluxDB service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Timestream InfluxDB.
//	func myFunc(svc timestreaminfluxdbiface.TimestreamInfluxDBAPI) bool {
//	    // Make svc.CreateDbInstance request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := timestreaminfluxdb.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockTimestreamInfluxDBClient struct {
//	    timestreaminfluxdbiface.TimestreamInfluxDBAPI
//	}
//	func (m *mockTimestreamInfluxDBClient) CreateDbInstance(input *timestreaminfluxdb.CreateDbInstanceInput) (*timestreaminfluxdb.CreateDbInstanceOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockTimestreamInfluxDBClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type TimestreamInfluxDBAPI interface {
	CreateDbInstance(*timestreaminfluxdb.CreateDbInstanceInput) (*timestreaminfluxdb.CreateDbInstanceOutput, error)
	CreateDbInstanceWithContext(aws.Context, *timestreaminfluxdb.CreateDbInstanceInput, ...request.Option) (*timestreaminfluxdb.CreateDbInstanceOutput, error)
	CreateDbInstanceRequest(*timestreaminfluxdb.CreateDbInstanceInput) (*request.Request, *timestreaminfluxdb.CreateDbInstanceOutput)

	CreateDbParameterGroup(*timestreaminfluxdb.CreateDbParameterGroupInput) (*timestreaminfluxdb.CreateDbParameterGroupOutput, error)
	CreateDbParameterGroupWithContext(aws.Context, *timestreaminfluxdb.CreateDbParameterGroupInput, ...request.Option) (*timestreaminfluxdb.CreateDbParameterGroupOutput, error)
	CreateDbParameterGroupRequest(*timestreaminfluxdb.CreateDbParameterGroupInput) (*request.Request, *timestreaminfluxdb.CreateDbParameterGroupOutput)

	DeleteDbInstance(*timestreaminfluxdb.DeleteDbInstanceInput) (*timestreaminfluxdb.DeleteDbInstanceOutput, error)
	DeleteDbInstanceWithContext(aws.Context, *timestreaminfluxdb.DeleteDbInstanceInput, ...request.Option) (*timestreaminfluxdb.DeleteDbInstanceOutput, error)
	DeleteDbInstanceRequest(*timestreaminfluxdb.DeleteDbInstanceInput) (*request.Request, *timestreaminfluxdb.DeleteDbInstanceOutput)

	GetDbInstance(*timestreaminfluxdb.GetDbInstanceInput) (*timestreaminfluxdb.GetDbInstanceOutput, error)
	GetDbInstanceWithContext(aws.Context, *timestreaminfluxdb.GetDbInstanceInput, ...request.Option) (*timestreaminfluxdb.GetDbInstanceOutput, error)
	GetDbInstanceRequest(*timestreaminfluxdb.GetDbInstanceInput) (*request.Request, *timestreaminfluxdb.GetDbInstanceOutput)

	GetDbParameterGroup(*timestreaminfluxdb.GetDbParameterGroupInput) (*timestreaminfluxdb.GetDbParameterGroupOutput, error)
	GetDbParameterGroupWithContext(aws.Context, *timestreaminfluxdb.GetDbParameterGroupInput, ...request.Option) (*timestreaminfluxdb.GetDbParameterGroupOutput, error)
	GetDbParameterGroupRequest(*timestreaminfluxdb.GetDbParameterGroupInput) (*request.Request, *timestreaminfluxdb.GetDbParameterGroupOutput)

	ListDbInstances(*timestreaminfluxdb.ListDbInstancesInput) (*timestreaminfluxdb.ListDbInstancesOutput, error)
	ListDbInstancesWithContext(aws.Context, *timestreaminfluxdb.ListDbInstancesInput, ...request.Option) (*timestreaminfluxdb.ListDbInstancesOutput, error)
	ListDbInstancesRequest(*timestreaminfluxdb.ListDbInstancesInput) (*request.Request, *timestreaminfluxdb.ListDbInstancesOutput)

	ListDbInstancesPages(*timestreaminfluxdb.ListDbInstancesInput, func(*timestreaminfluxdb.ListDbInstancesOutput, bool) bool) error
	ListDbInstancesPagesWithContext(aws.Context, *timestreaminfluxdb.ListDbInstancesInput, func(*timestreaminfluxdb.ListDbInstancesOutput, bool) bool, ...request.Option) error

	ListDbParameterGroups(*timestreaminfluxdb.ListDbParameterGroupsInput) (*timestreaminfluxdb.ListDbParameterGroupsOutput, error)
	ListDbParameterGroupsWithContext(aws.Context, *timestreaminfluxdb.ListDbParameterGroupsInput, ...request.Option) (*timestreaminfluxdb.ListDbParameterGroupsOutput, error)
	ListDbParameterGroupsRequest(*timestreaminfluxdb.ListDbParameterGroupsInput) (*request.Request, *timestreaminfluxdb.ListDbParameterGroupsOutput)

	ListDbParameterGroupsPages(*timestreaminfluxdb.ListDbParameterGroupsInput, func(*timestreaminfluxdb.ListDbParameterGroupsOutput, bool) bool) error
	ListDbParameterGroupsPagesWithContext(aws.Context, *timestreaminfluxdb.ListDbParameterGroupsInput, func(*timestreaminfluxdb.ListDbParameterGroupsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*timestreaminfluxdb.ListTagsForResourceInput) (*timestreaminfluxdb.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *timestreaminfluxdb.ListTagsForResourceInput, ...request.Option) (*timestreaminfluxdb.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*timestreaminfluxdb.ListTagsForResourceInput) (*request.Request, *timestreaminfluxdb.ListTagsForResourceOutput)

	TagResource(*timestreaminfluxdb.TagResourceInput) (*timestreaminfluxdb.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *timestreaminfluxdb.TagResourceInput, ...request.Option) (*timestreaminfluxdb.TagResourceOutput, error)
	TagResourceRequest(*timestreaminfluxdb.TagResourceInput) (*request.Request, *timestreaminfluxdb.TagResourceOutput)

	UntagResource(*timestreaminfluxdb.UntagResourceInput) (*timestreaminfluxdb.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *timestreaminfluxdb.UntagResourceInput, ...request.Option) (*timestreaminfluxdb.UntagResourceOutput, error)
	UntagResourceRequest(*timestreaminfluxdb.UntagResourceInput) (*request.Request, *timestreaminfluxdb.UntagResourceOutput)

	UpdateDbInstance(*timestreaminfluxdb.UpdateDbInstanceInput) (*timestreaminfluxdb.UpdateDbInstanceOutput, error)
	UpdateDbInstanceWithContext(aws.Context, *timestreaminfluxdb.UpdateDbInstanceInput, ...request.Option) (*timestreaminfluxdb.UpdateDbInstanceOutput, error)
	UpdateDbInstanceRequest(*timestreaminfluxdb.UpdateDbInstanceInput) (*request.Request, *timestreaminfluxdb.UpdateDbInstanceOutput)
}

var _ TimestreamInfluxDBAPI = (*timestreaminfluxdb.TimestreamInfluxDB)(nil)
