// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

/*
Package log provides the OpenTelemetry Logs SDK.

See https://opentelemetry.io/docs/concepts/signals/logs/ for information
about the concept of OpenTelemetry Logs and
https://opentelemetry.io/docs/concepts/components/ for more information
about OpenTelemetry SDKs.

The entry point for the log package is [NewLoggerProvider].
[LoggerProvider] is the object that all Bridge API calls use to create
Loggers, and ultimately emit log records.
Also, it is an object that should be used to
control the life-cycle (start, flush, and shutdown) of the Logs SDK.

A LoggerProvider needs to be configured to process the log records, this is
done by configuring it with a [Processor] implementation using [WithProcessor].
The log package provides the [BatchProcessor] and [SimpleProcessor]
that are configured with an [Exporter] implementation which
exports the log records to given destination. See
[go.opentelemetry.io/otel/exporters] for exporters that can be used with these
Processors.

The data generated by a LoggerProvider needs to include information about its
origin. A LoggerProvider needs to be configured with a Resource, by using
[WithResource], to include this information. This Resource
should be used to describe the unique runtime environment instrumented code
is being run on. That way when multiple instances of the code are collected
at a single endpoint their origin is decipherable.

See [go.opentelemetry.io/otel/log] for more information about
the OpenTelemetry Logs Bridge API.
*/
package log // import "go.opentelemetry.io/otel/sdk/log"
