// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ScrapeConfigLister helps list ScrapeConfigs.
// All objects returned here must be treated as read-only.
type ScrapeConfigLister interface {
	// List lists all ScrapeConfigs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ScrapeConfig, err error)
	// ScrapeConfigs returns an object that can list and get ScrapeConfigs.
	ScrapeConfigs(namespace string) ScrapeConfigNamespaceLister
	ScrapeConfigListerExpansion
}

// scrapeConfigLister implements the ScrapeConfigLister interface.
type scrapeConfigLister struct {
	indexer cache.Indexer
}

// NewScrapeConfigLister returns a new ScrapeConfigLister.
func NewScrapeConfigLister(indexer cache.Indexer) ScrapeConfigLister {
	return &scrapeConfigLister{indexer: indexer}
}

// List lists all ScrapeConfigs in the indexer.
func (s *scrapeConfigLister) List(selector labels.Selector) (ret []*v1alpha1.ScrapeConfig, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ScrapeConfig))
	})
	return ret, err
}

// ScrapeConfigs returns an object that can list and get ScrapeConfigs.
func (s *scrapeConfigLister) ScrapeConfigs(namespace string) ScrapeConfigNamespaceLister {
	return scrapeConfigNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ScrapeConfigNamespaceLister helps list and get ScrapeConfigs.
// All objects returned here must be treated as read-only.
type ScrapeConfigNamespaceLister interface {
	// List lists all ScrapeConfigs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ScrapeConfig, err error)
	// Get retrieves the ScrapeConfig from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.ScrapeConfig, error)
	ScrapeConfigNamespaceListerExpansion
}

// scrapeConfigNamespaceLister implements the ScrapeConfigNamespaceLister
// interface.
type scrapeConfigNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ScrapeConfigs in the indexer for a given namespace.
func (s scrapeConfigNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.ScrapeConfig, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ScrapeConfig))
	})
	return ret, err
}

// Get retrieves the ScrapeConfig from the indexer for a given namespace and name.
func (s scrapeConfigNamespaceLister) Get(name string) (*v1alpha1.ScrapeConfig, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("scrapeconfig"), name)
	}
	return obj.(*v1alpha1.ScrapeConfig), nil
}
