// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// TimeIntervalApplyConfiguration represents an declarative configuration of the TimeInterval type for use
// with apply.
type TimeIntervalApplyConfiguration struct {
	Name          *string                        `json:"name,omitempty"`
	TimeIntervals []TimePeriodApplyConfiguration `json:"timeIntervals,omitempty"`
}

// TimeIntervalApplyConfiguration constructs an declarative configuration of the TimeInterval type for use with
// apply.
func TimeInterval() *TimeIntervalApplyConfiguration {
	return &TimeIntervalApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *TimeIntervalApplyConfiguration) WithName(value string) *TimeIntervalApplyConfiguration {
	b.Name = &value
	return b
}

// WithTimeIntervals adds the given value to the TimeIntervals field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the TimeIntervals field.
func (b *TimeIntervalApplyConfiguration) WithTimeIntervals(values ...*TimePeriodApplyConfiguration) *TimeIntervalApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTimeIntervals")
		}
		b.TimeIntervals = append(b.TimeIntervals, *values[i])
	}
	return b
}
