// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// WebHTTPHeadersApplyConfiguration represents an declarative configuration of the WebHTTPHeaders type for use
// with apply.
type WebHTTPHeadersApplyConfiguration struct {
	ContentSecurityPolicy   *string `json:"contentSecurityPolicy,omitempty"`
	XFrameOptions           *string `json:"xFrameOptions,omitempty"`
	XContentTypeOptions     *string `json:"xContentTypeOptions,omitempty"`
	XXSSProtection          *string `json:"xXSSProtection,omitempty"`
	StrictTransportSecurity *string `json:"strictTransportSecurity,omitempty"`
}

// WebHTTPHeadersApplyConfiguration constructs an declarative configuration of the WebHTTPHeaders type for use with
// apply.
func WebHTTPHeaders() *WebHTTPHeadersApplyConfiguration {
	return &WebHTTPHeadersApplyConfiguration{}
}

// WithContentSecurityPolicy sets the ContentSecurityPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ContentSecurityPolicy field is set to the value of the last call.
func (b *WebHTTPHeadersApplyConfiguration) WithContentSecurityPolicy(value string) *WebHTTPHeadersApplyConfiguration {
	b.ContentSecurityPolicy = &value
	return b
}

// WithXFrameOptions sets the XFrameOptions field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the XFrameOptions field is set to the value of the last call.
func (b *WebHTTPHeadersApplyConfiguration) WithXFrameOptions(value string) *WebHTTPHeadersApplyConfiguration {
	b.XFrameOptions = &value
	return b
}

// WithXContentTypeOptions sets the XContentTypeOptions field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the XContentTypeOptions field is set to the value of the last call.
func (b *WebHTTPHeadersApplyConfiguration) WithXContentTypeOptions(value string) *WebHTTPHeadersApplyConfiguration {
	b.XContentTypeOptions = &value
	return b
}

// WithXXSSProtection sets the XXSSProtection field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the XXSSProtection field is set to the value of the last call.
func (b *WebHTTPHeadersApplyConfiguration) WithXXSSProtection(value string) *WebHTTPHeadersApplyConfiguration {
	b.XXSSProtection = &value
	return b
}

// WithStrictTransportSecurity sets the StrictTransportSecurity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StrictTransportSecurity field is set to the value of the last call.
func (b *WebHTTPHeadersApplyConfiguration) WithStrictTransportSecurity(value string) *WebHTTPHeadersApplyConfiguration {
	b.StrictTransportSecurity = &value
	return b
}
