// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
)

// QuerySpecApplyConfiguration represents an declarative configuration of the QuerySpec type for use
// with apply.
type QuerySpecApplyConfiguration struct {
	LookbackDelta  *string      `json:"lookbackDelta,omitempty"`
	MaxConcurrency *int32       `json:"maxConcurrency,omitempty"`
	MaxSamples     *int32       `json:"maxSamples,omitempty"`
	Timeout        *v1.Duration `json:"timeout,omitempty"`
}

// QuerySpecApplyConfiguration constructs an declarative configuration of the QuerySpec type for use with
// apply.
func QuerySpec() *QuerySpecApplyConfiguration {
	return &QuerySpecApplyConfiguration{}
}

// WithLookbackDelta sets the LookbackDelta field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LookbackDelta field is set to the value of the last call.
func (b *QuerySpecApplyConfiguration) WithLookbackDelta(value string) *QuerySpecApplyConfiguration {
	b.LookbackDelta = &value
	return b
}

// WithMaxConcurrency sets the MaxConcurrency field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxConcurrency field is set to the value of the last call.
func (b *QuerySpecApplyConfiguration) WithMaxConcurrency(value int32) *QuerySpecApplyConfiguration {
	b.MaxConcurrency = &value
	return b
}

// WithMaxSamples sets the MaxSamples field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxSamples field is set to the value of the last call.
func (b *QuerySpecApplyConfiguration) WithMaxSamples(value int32) *QuerySpecApplyConfiguration {
	b.MaxSamples = &value
	return b
}

// WithTimeout sets the Timeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Timeout field is set to the value of the last call.
func (b *QuerySpecApplyConfiguration) WithTimeout(value v1.Duration) *QuerySpecApplyConfiguration {
	b.Timeout = &value
	return b
}
