// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apismonitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// ProbeTargetIngressApplyConfiguration represents an declarative configuration of the ProbeTargetIngress type for use
// with apply.
type ProbeTargetIngressApplyConfiguration struct {
	Selector          *v1.LabelSelector                    `json:"selector,omitempty"`
	NamespaceSelector *NamespaceSelectorApplyConfiguration `json:"namespaceSelector,omitempty"`
	RelabelConfigs    []*apismonitoringv1.RelabelConfig    `json:"relabelingConfigs,omitempty"`
}

// ProbeTargetIngressApplyConfiguration constructs an declarative configuration of the ProbeTargetIngress type for use with
// apply.
func ProbeTargetIngress() *ProbeTargetIngressApplyConfiguration {
	return &ProbeTargetIngressApplyConfiguration{}
}

// WithSelector sets the Selector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Selector field is set to the value of the last call.
func (b *ProbeTargetIngressApplyConfiguration) WithSelector(value v1.LabelSelector) *ProbeTargetIngressApplyConfiguration {
	b.Selector = &value
	return b
}

// WithNamespaceSelector sets the NamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NamespaceSelector field is set to the value of the last call.
func (b *ProbeTargetIngressApplyConfiguration) WithNamespaceSelector(value *NamespaceSelectorApplyConfiguration) *ProbeTargetIngressApplyConfiguration {
	b.NamespaceSelector = value
	return b
}

// WithRelabelConfigs adds the given value to the RelabelConfigs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RelabelConfigs field.
func (b *ProbeTargetIngressApplyConfiguration) WithRelabelConfigs(values ...**apismonitoringv1.RelabelConfig) *ProbeTargetIngressApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRelabelConfigs")
		}
		b.RelabelConfigs = append(b.RelabelConfigs, *values[i])
	}
	return b
}
