// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package gotracer

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type bpfConnectionInfoT struct {
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type bpfEgressKeyT struct {
	S_port uint16
	D_port uint16
}

type bpfGoAddrKeyT struct {
	Pid  uint64
	Addr uint64
}

type bpfGoroutineMetadata struct {
	Parent    bpfGoAddrKeyT
	Timestamp uint64
}

type bpfGrpcClientFuncInvocationT struct {
	StartMonotimeNs uint64
	Cc              uint64
	Method          uint64
	MethodLen       uint64
	Tp              bpfTpInfoT
	Flags           uint64
}

type bpfGrpcSrvFuncInvocationT struct {
	StartMonotimeNs uint64
	Stream          uint64
	St              uint64
	Tp              bpfTpInfoT
}

type bpfGrpcTransportsT struct {
	Conn bpfConnectionInfoT
	Type uint8
	Pad  [3]uint8
	Tp   bpfTpInfoT
}

type bpfHttpClientDataT struct {
	ContentLength int64
	Pid           struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Path   [100]uint8
	Host   [100]uint8
	Scheme [10]uint8
	Method [7]uint8
	Pad    [3]uint8
}

type bpfHttpFuncInvocationT struct {
	StartMonotimeNs uint64
	Tp              bpfTpInfoT
}

type bpfKafkaClientReqT struct {
	Type            uint8
	Pad             [7]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Buf             [256]uint8
	Conn            bpfConnectionInfoT
	Pid             struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
}

type bpfKafkaGoReqT struct {
	Type uint8
	Op   uint8
	Pad0 [2]uint8
	Pid  struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Conn            bpfConnectionInfoT
	Pad1            [4]uint8
	Tp              bpfTpInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Topic           [64]uint8
}

type bpfNewFuncInvocationT struct{ Parent uint64 }

type bpfOffTableT struct{ Table [50]uint64 }

type bpfProduceReqT struct {
	MsgPtr          uint64
	ConnPtr         uint64
	StartMonotimeNs uint64
}

type bpfRedisClientReqT struct {
	Type            uint8
	Err             uint8
	Pad             [6]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Pid             struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Buf  [256]uint8
	Conn bpfConnectionInfoT
	Tp   bpfTpInfoT
}

type bpfServerHttpFuncInvocationT struct {
	StartMonotimeNs uint64
	ContentLength   uint64
	ResponseLength  uint64
	Status          uint64
	Tp              bpfTpInfoT
	Method          [7]uint8
	Path            [100]uint8
	Pad             [5]uint8
}

type bpfSqlFuncInvocationT struct {
	StartMonotimeNs uint64
	SqlParam        uint64
	QueryLen        uint64
	Tp              bpfTpInfoT
	Conn            bpfConnectionInfoT
	Pad             [4]uint8
}

type bpfTopicT struct {
	Name [64]int8
	Tp   bpfTpInfoT
}

type bpfTpInfoPidT struct {
	Tp      bpfTpInfoT
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type bpfTpInfoT struct {
	TraceId  [16]uint8
	SpanId   [8]uint8
	ParentId [8]uint8
	Ts       uint64
	Flags    uint8
	Pad      [7]uint8
}

type bpfTraceMapKeyT struct {
	Conn bpfConnectionInfoT
	Type uint32
}

// loadBpf returns the embedded CollectionSpec for bpf.
func loadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load bpf: %w", err)
	}

	return spec, err
}

// loadBpfObjects loads bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*bpfObjects
//	*bpfPrograms
//	*bpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// bpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfSpecs struct {
	bpfProgramSpecs
	bpfMapSpecs
	bpfVariableSpecs
}

// bpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfProgramSpecs struct {
	BeylaUprobeClientConnClose                     *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ClientConn_Close"`
	BeylaUprobeClientConnInvoke                    *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ClientConn_Invoke"`
	BeylaUprobeClientConnInvokeReturn              *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ClientConn_Invoke_return"`
	BeylaUprobeClientConnNewStream                 *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ClientConn_NewStream"`
	BeylaUprobeClientConnNewStreamReturn           *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ClientConn_NewStream_return"`
	BeylaUprobeServeHTTP                           *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ServeHTTP"`
	BeylaUprobeServeHTTPReturns                    *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ServeHTTPReturns"`
	BeylaUprobeClientStreamRecvMsgReturn           *ebpf.ProgramSpec `ebpf:"beyla_uprobe_clientStream_RecvMsg_return"`
	BeylaUprobeClientRoundTrip                     *ebpf.ProgramSpec `ebpf:"beyla_uprobe_client_roundTrip"`
	BeylaUprobeConnServe                           *ebpf.ProgramSpec `ebpf:"beyla_uprobe_connServe"`
	BeylaUprobeConnServeRet                        *ebpf.ProgramSpec `ebpf:"beyla_uprobe_connServeRet"`
	BeylaUprobeExecDC                              *ebpf.ProgramSpec `ebpf:"beyla_uprobe_execDC"`
	BeylaUprobeGrpcFramerWriteHeaders              *ebpf.ProgramSpec `ebpf:"beyla_uprobe_grpcFramerWriteHeaders"`
	BeylaUprobeGrpcFramerWriteHeadersReturns       *ebpf.ProgramSpec `ebpf:"beyla_uprobe_grpcFramerWriteHeaders_returns"`
	BeylaUprobeHttp2FramerWriteHeaders             *ebpf.ProgramSpec `ebpf:"beyla_uprobe_http2FramerWriteHeaders"`
	BeylaUprobeHttp2FramerWriteHeadersReturns      *ebpf.ProgramSpec `ebpf:"beyla_uprobe_http2FramerWriteHeaders_returns"`
	BeylaUprobeHttp2ResponseWriterStateWriteHeader *ebpf.ProgramSpec `ebpf:"beyla_uprobe_http2ResponseWriterStateWriteHeader"`
	BeylaUprobeHttp2RoundTrip                      *ebpf.ProgramSpec `ebpf:"beyla_uprobe_http2RoundTrip"`
	BeylaUprobeHttp2RoundTripConn                  *ebpf.ProgramSpec `ebpf:"beyla_uprobe_http2RoundTripConn"`
	BeylaUprobeHttp2ServerOperateHeaders           *ebpf.ProgramSpec `ebpf:"beyla_uprobe_http2Server_operateHeaders"`
	BeylaUprobeHttp2ServerProcessHeaders           *ebpf.ProgramSpec `ebpf:"beyla_uprobe_http2Server_processHeaders"`
	BeylaUprobeHttp2serverConnRunHandler           *ebpf.ProgramSpec `ebpf:"beyla_uprobe_http2serverConn_runHandler"`
	BeylaUprobeNetFdRead                           *ebpf.ProgramSpec `ebpf:"beyla_uprobe_netFdRead"`
	BeylaUprobePersistConnRoundTrip                *ebpf.ProgramSpec `ebpf:"beyla_uprobe_persistConnRoundTrip"`
	BeylaUprobeProcGoexit1                         *ebpf.ProgramSpec `ebpf:"beyla_uprobe_proc_goexit1"`
	BeylaUprobeProcNewproc1                        *ebpf.ProgramSpec `ebpf:"beyla_uprobe_proc_newproc1"`
	BeylaUprobeProcNewproc1Ret                     *ebpf.ProgramSpec `ebpf:"beyla_uprobe_proc_newproc1_ret"`
	BeylaUprobeProtocolRoundtrip                   *ebpf.ProgramSpec `ebpf:"beyla_uprobe_protocol_roundtrip"`
	BeylaUprobeProtocolRoundtripRet                *ebpf.ProgramSpec `ebpf:"beyla_uprobe_protocol_roundtrip_ret"`
	BeylaUprobeQueryDC                             *ebpf.ProgramSpec `ebpf:"beyla_uprobe_queryDC"`
	BeylaUprobeQueryReturn                         *ebpf.ProgramSpec `ebpf:"beyla_uprobe_queryReturn"`
	BeylaUprobeReadContinuedLineSliceReturns       *ebpf.ProgramSpec `ebpf:"beyla_uprobe_readContinuedLineSliceReturns"`
	BeylaUprobeReadRequestReturns                  *ebpf.ProgramSpec `ebpf:"beyla_uprobe_readRequestReturns"`
	BeylaUprobeReadRequestStart                    *ebpf.ProgramSpec `ebpf:"beyla_uprobe_readRequestStart"`
	BeylaUprobeReaderRead                          *ebpf.ProgramSpec `ebpf:"beyla_uprobe_reader_read"`
	BeylaUprobeReaderReadRet                       *ebpf.ProgramSpec `ebpf:"beyla_uprobe_reader_read_ret"`
	BeylaUprobeReaderSendMessage                   *ebpf.ProgramSpec `ebpf:"beyla_uprobe_reader_send_message"`
	BeylaUprobeRedisProcess                        *ebpf.ProgramSpec `ebpf:"beyla_uprobe_redis_process"`
	BeylaUprobeRedisProcessRet                     *ebpf.ProgramSpec `ebpf:"beyla_uprobe_redis_process_ret"`
	BeylaUprobeRedisWithWriter                     *ebpf.ProgramSpec `ebpf:"beyla_uprobe_redis_with_writer"`
	BeylaUprobeRedisWithWriterRet                  *ebpf.ProgramSpec `ebpf:"beyla_uprobe_redis_with_writer_ret"`
	BeylaUprobeRoundTrip                           *ebpf.ProgramSpec `ebpf:"beyla_uprobe_roundTrip"`
	BeylaUprobeRoundTripReturn                     *ebpf.ProgramSpec `ebpf:"beyla_uprobe_roundTripReturn"`
	BeylaUprobeSaramaBrokerWrite                   *ebpf.ProgramSpec `ebpf:"beyla_uprobe_sarama_broker_write"`
	BeylaUprobeSaramaResponsePromiseHandle         *ebpf.ProgramSpec `ebpf:"beyla_uprobe_sarama_response_promise_handle"`
	BeylaUprobeSaramaSendInternal                  *ebpf.ProgramSpec `ebpf:"beyla_uprobe_sarama_sendInternal"`
	BeylaUprobeServerHandleStream                  *ebpf.ProgramSpec `ebpf:"beyla_uprobe_server_handleStream"`
	BeylaUprobeServerHandleStreamReturn            *ebpf.ProgramSpec `ebpf:"beyla_uprobe_server_handleStream_return"`
	BeylaUprobeServerHandlerTransportHandleStreams *ebpf.ProgramSpec `ebpf:"beyla_uprobe_server_handler_transport_handle_streams"`
	BeylaUprobeTransportHttp2ClientNewStream       *ebpf.ProgramSpec `ebpf:"beyla_uprobe_transport_http2Client_NewStream"`
	BeylaUprobeTransportWriteStatus                *ebpf.ProgramSpec `ebpf:"beyla_uprobe_transport_writeStatus"`
	BeylaUprobeWriteSubset                         *ebpf.ProgramSpec `ebpf:"beyla_uprobe_writeSubset"`
	BeylaUprobeWriterProduce                       *ebpf.ProgramSpec `ebpf:"beyla_uprobe_writer_produce"`
	BeylaUprobeWriterWriteMessages                 *ebpf.ProgramSpec `ebpf:"beyla_uprobe_writer_write_messages"`
}

// bpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfMapSpecs struct {
	Events                        *ebpf.MapSpec `ebpf:"events"`
	FetchRequests                 *ebpf.MapSpec `ebpf:"fetch_requests"`
	GoOffsetsMap                  *ebpf.MapSpec `ebpf:"go_offsets_map"`
	GoOngoingHttp                 *ebpf.MapSpec `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests   *ebpf.MapSpec `ebpf:"go_ongoing_http_client_requests"`
	GoTraceMap                    *ebpf.MapSpec `ebpf:"go_trace_map"`
	Http2ServerRequestsTp         *ebpf.MapSpec `ebpf:"http2_server_requests_tp"`
	IncomingTraceMap              *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	KafkaRequests                 *ebpf.MapSpec `ebpf:"kafka_requests"`
	Newproc1                      *ebpf.MapSpec `ebpf:"newproc1"`
	OngoingClientConnections      *ebpf.MapSpec `ebpf:"ongoing_client_connections"`
	OngoingGoroutines             *ebpf.MapSpec `ebpf:"ongoing_goroutines"`
	OngoingGrpcClientRequests     *ebpf.MapSpec `ebpf:"ongoing_grpc_client_requests"`
	OngoingGrpcHeaderWrites       *ebpf.MapSpec `ebpf:"ongoing_grpc_header_writes"`
	OngoingGrpcOperateHeaders     *ebpf.MapSpec `ebpf:"ongoing_grpc_operate_headers"`
	OngoingGrpcRequestStatus      *ebpf.MapSpec `ebpf:"ongoing_grpc_request_status"`
	OngoingGrpcServerRequests     *ebpf.MapSpec `ebpf:"ongoing_grpc_server_requests"`
	OngoingGrpcTransports         *ebpf.MapSpec `ebpf:"ongoing_grpc_transports"`
	OngoingHttpClientRequestsData *ebpf.MapSpec `ebpf:"ongoing_http_client_requests_data"`
	OngoingHttpServerRequests     *ebpf.MapSpec `ebpf:"ongoing_http_server_requests"`
	OngoingKafkaRequests          *ebpf.MapSpec `ebpf:"ongoing_kafka_requests"`
	OngoingProduceMessages        *ebpf.MapSpec `ebpf:"ongoing_produce_messages"`
	OngoingProduceTopics          *ebpf.MapSpec `ebpf:"ongoing_produce_topics"`
	OngoingRedisRequests          *ebpf.MapSpec `ebpf:"ongoing_redis_requests"`
	OngoingServerConnections      *ebpf.MapSpec `ebpf:"ongoing_server_connections"`
	OngoingSqlQueries             *ebpf.MapSpec `ebpf:"ongoing_sql_queries"`
	OngoingStreams                *ebpf.MapSpec `ebpf:"ongoing_streams"`
	OutgoingTraceMap              *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	ProduceRequests               *ebpf.MapSpec `ebpf:"produce_requests"`
	ProduceTraceparents           *ebpf.MapSpec `ebpf:"produce_traceparents"`
	RedisWrites                   *ebpf.MapSpec `ebpf:"redis_writes"`
	TraceMap                      *ebpf.MapSpec `ebpf:"trace_map"`
}

// bpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfVariableSpecs struct {
	DisableBlackBoxCp *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	HuffmanCodeLen    *ebpf.VariableSpec `ebpf:"huffman_code_len"`
	HuffmanCodes      *ebpf.VariableSpec `ebpf:"huffman_codes"`
	Ip4ip6Prefix      *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2       *ebpf.VariableSpec `ebpf:"unused_http2"`
	WakeupDataBytes   *ebpf.VariableSpec `ebpf:"wakeup_data_bytes"`
}

// bpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfObjects struct {
	bpfPrograms
	bpfMaps
	bpfVariables
}

func (o *bpfObjects) Close() error {
	return _BpfClose(
		&o.bpfPrograms,
		&o.bpfMaps,
	)
}

// bpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfMaps struct {
	Events                        *ebpf.Map `ebpf:"events"`
	FetchRequests                 *ebpf.Map `ebpf:"fetch_requests"`
	GoOffsetsMap                  *ebpf.Map `ebpf:"go_offsets_map"`
	GoOngoingHttp                 *ebpf.Map `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests   *ebpf.Map `ebpf:"go_ongoing_http_client_requests"`
	GoTraceMap                    *ebpf.Map `ebpf:"go_trace_map"`
	Http2ServerRequestsTp         *ebpf.Map `ebpf:"http2_server_requests_tp"`
	IncomingTraceMap              *ebpf.Map `ebpf:"incoming_trace_map"`
	KafkaRequests                 *ebpf.Map `ebpf:"kafka_requests"`
	Newproc1                      *ebpf.Map `ebpf:"newproc1"`
	OngoingClientConnections      *ebpf.Map `ebpf:"ongoing_client_connections"`
	OngoingGoroutines             *ebpf.Map `ebpf:"ongoing_goroutines"`
	OngoingGrpcClientRequests     *ebpf.Map `ebpf:"ongoing_grpc_client_requests"`
	OngoingGrpcHeaderWrites       *ebpf.Map `ebpf:"ongoing_grpc_header_writes"`
	OngoingGrpcOperateHeaders     *ebpf.Map `ebpf:"ongoing_grpc_operate_headers"`
	OngoingGrpcRequestStatus      *ebpf.Map `ebpf:"ongoing_grpc_request_status"`
	OngoingGrpcServerRequests     *ebpf.Map `ebpf:"ongoing_grpc_server_requests"`
	OngoingGrpcTransports         *ebpf.Map `ebpf:"ongoing_grpc_transports"`
	OngoingHttpClientRequestsData *ebpf.Map `ebpf:"ongoing_http_client_requests_data"`
	OngoingHttpServerRequests     *ebpf.Map `ebpf:"ongoing_http_server_requests"`
	OngoingKafkaRequests          *ebpf.Map `ebpf:"ongoing_kafka_requests"`
	OngoingProduceMessages        *ebpf.Map `ebpf:"ongoing_produce_messages"`
	OngoingProduceTopics          *ebpf.Map `ebpf:"ongoing_produce_topics"`
	OngoingRedisRequests          *ebpf.Map `ebpf:"ongoing_redis_requests"`
	OngoingServerConnections      *ebpf.Map `ebpf:"ongoing_server_connections"`
	OngoingSqlQueries             *ebpf.Map `ebpf:"ongoing_sql_queries"`
	OngoingStreams                *ebpf.Map `ebpf:"ongoing_streams"`
	OutgoingTraceMap              *ebpf.Map `ebpf:"outgoing_trace_map"`
	ProduceRequests               *ebpf.Map `ebpf:"produce_requests"`
	ProduceTraceparents           *ebpf.Map `ebpf:"produce_traceparents"`
	RedisWrites                   *ebpf.Map `ebpf:"redis_writes"`
	TraceMap                      *ebpf.Map `ebpf:"trace_map"`
}

func (m *bpfMaps) Close() error {
	return _BpfClose(
		m.Events,
		m.FetchRequests,
		m.GoOffsetsMap,
		m.GoOngoingHttp,
		m.GoOngoingHttpClientRequests,
		m.GoTraceMap,
		m.Http2ServerRequestsTp,
		m.IncomingTraceMap,
		m.KafkaRequests,
		m.Newproc1,
		m.OngoingClientConnections,
		m.OngoingGoroutines,
		m.OngoingGrpcClientRequests,
		m.OngoingGrpcHeaderWrites,
		m.OngoingGrpcOperateHeaders,
		m.OngoingGrpcRequestStatus,
		m.OngoingGrpcServerRequests,
		m.OngoingGrpcTransports,
		m.OngoingHttpClientRequestsData,
		m.OngoingHttpServerRequests,
		m.OngoingKafkaRequests,
		m.OngoingProduceMessages,
		m.OngoingProduceTopics,
		m.OngoingRedisRequests,
		m.OngoingServerConnections,
		m.OngoingSqlQueries,
		m.OngoingStreams,
		m.OutgoingTraceMap,
		m.ProduceRequests,
		m.ProduceTraceparents,
		m.RedisWrites,
		m.TraceMap,
	)
}

// bpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfVariables struct {
	DisableBlackBoxCp *ebpf.Variable `ebpf:"disable_black_box_cp"`
	HuffmanCodeLen    *ebpf.Variable `ebpf:"huffman_code_len"`
	HuffmanCodes      *ebpf.Variable `ebpf:"huffman_codes"`
	Ip4ip6Prefix      *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2       *ebpf.Variable `ebpf:"unused_http2"`
	WakeupDataBytes   *ebpf.Variable `ebpf:"wakeup_data_bytes"`
}

// bpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfPrograms struct {
	BeylaUprobeClientConnClose                     *ebpf.Program `ebpf:"beyla_uprobe_ClientConn_Close"`
	BeylaUprobeClientConnInvoke                    *ebpf.Program `ebpf:"beyla_uprobe_ClientConn_Invoke"`
	BeylaUprobeClientConnInvokeReturn              *ebpf.Program `ebpf:"beyla_uprobe_ClientConn_Invoke_return"`
	BeylaUprobeClientConnNewStream                 *ebpf.Program `ebpf:"beyla_uprobe_ClientConn_NewStream"`
	BeylaUprobeClientConnNewStreamReturn           *ebpf.Program `ebpf:"beyla_uprobe_ClientConn_NewStream_return"`
	BeylaUprobeServeHTTP                           *ebpf.Program `ebpf:"beyla_uprobe_ServeHTTP"`
	BeylaUprobeServeHTTPReturns                    *ebpf.Program `ebpf:"beyla_uprobe_ServeHTTPReturns"`
	BeylaUprobeClientStreamRecvMsgReturn           *ebpf.Program `ebpf:"beyla_uprobe_clientStream_RecvMsg_return"`
	BeylaUprobeClientRoundTrip                     *ebpf.Program `ebpf:"beyla_uprobe_client_roundTrip"`
	BeylaUprobeConnServe                           *ebpf.Program `ebpf:"beyla_uprobe_connServe"`
	BeylaUprobeConnServeRet                        *ebpf.Program `ebpf:"beyla_uprobe_connServeRet"`
	BeylaUprobeExecDC                              *ebpf.Program `ebpf:"beyla_uprobe_execDC"`
	BeylaUprobeGrpcFramerWriteHeaders              *ebpf.Program `ebpf:"beyla_uprobe_grpcFramerWriteHeaders"`
	BeylaUprobeGrpcFramerWriteHeadersReturns       *ebpf.Program `ebpf:"beyla_uprobe_grpcFramerWriteHeaders_returns"`
	BeylaUprobeHttp2FramerWriteHeaders             *ebpf.Program `ebpf:"beyla_uprobe_http2FramerWriteHeaders"`
	BeylaUprobeHttp2FramerWriteHeadersReturns      *ebpf.Program `ebpf:"beyla_uprobe_http2FramerWriteHeaders_returns"`
	BeylaUprobeHttp2ResponseWriterStateWriteHeader *ebpf.Program `ebpf:"beyla_uprobe_http2ResponseWriterStateWriteHeader"`
	BeylaUprobeHttp2RoundTrip                      *ebpf.Program `ebpf:"beyla_uprobe_http2RoundTrip"`
	BeylaUprobeHttp2RoundTripConn                  *ebpf.Program `ebpf:"beyla_uprobe_http2RoundTripConn"`
	BeylaUprobeHttp2ServerOperateHeaders           *ebpf.Program `ebpf:"beyla_uprobe_http2Server_operateHeaders"`
	BeylaUprobeHttp2ServerProcessHeaders           *ebpf.Program `ebpf:"beyla_uprobe_http2Server_processHeaders"`
	BeylaUprobeHttp2serverConnRunHandler           *ebpf.Program `ebpf:"beyla_uprobe_http2serverConn_runHandler"`
	BeylaUprobeNetFdRead                           *ebpf.Program `ebpf:"beyla_uprobe_netFdRead"`
	BeylaUprobePersistConnRoundTrip                *ebpf.Program `ebpf:"beyla_uprobe_persistConnRoundTrip"`
	BeylaUprobeProcGoexit1                         *ebpf.Program `ebpf:"beyla_uprobe_proc_goexit1"`
	BeylaUprobeProcNewproc1                        *ebpf.Program `ebpf:"beyla_uprobe_proc_newproc1"`
	BeylaUprobeProcNewproc1Ret                     *ebpf.Program `ebpf:"beyla_uprobe_proc_newproc1_ret"`
	BeylaUprobeProtocolRoundtrip                   *ebpf.Program `ebpf:"beyla_uprobe_protocol_roundtrip"`
	BeylaUprobeProtocolRoundtripRet                *ebpf.Program `ebpf:"beyla_uprobe_protocol_roundtrip_ret"`
	BeylaUprobeQueryDC                             *ebpf.Program `ebpf:"beyla_uprobe_queryDC"`
	BeylaUprobeQueryReturn                         *ebpf.Program `ebpf:"beyla_uprobe_queryReturn"`
	BeylaUprobeReadContinuedLineSliceReturns       *ebpf.Program `ebpf:"beyla_uprobe_readContinuedLineSliceReturns"`
	BeylaUprobeReadRequestReturns                  *ebpf.Program `ebpf:"beyla_uprobe_readRequestReturns"`
	BeylaUprobeReadRequestStart                    *ebpf.Program `ebpf:"beyla_uprobe_readRequestStart"`
	BeylaUprobeReaderRead                          *ebpf.Program `ebpf:"beyla_uprobe_reader_read"`
	BeylaUprobeReaderReadRet                       *ebpf.Program `ebpf:"beyla_uprobe_reader_read_ret"`
	BeylaUprobeReaderSendMessage                   *ebpf.Program `ebpf:"beyla_uprobe_reader_send_message"`
	BeylaUprobeRedisProcess                        *ebpf.Program `ebpf:"beyla_uprobe_redis_process"`
	BeylaUprobeRedisProcessRet                     *ebpf.Program `ebpf:"beyla_uprobe_redis_process_ret"`
	BeylaUprobeRedisWithWriter                     *ebpf.Program `ebpf:"beyla_uprobe_redis_with_writer"`
	BeylaUprobeRedisWithWriterRet                  *ebpf.Program `ebpf:"beyla_uprobe_redis_with_writer_ret"`
	BeylaUprobeRoundTrip                           *ebpf.Program `ebpf:"beyla_uprobe_roundTrip"`
	BeylaUprobeRoundTripReturn                     *ebpf.Program `ebpf:"beyla_uprobe_roundTripReturn"`
	BeylaUprobeSaramaBrokerWrite                   *ebpf.Program `ebpf:"beyla_uprobe_sarama_broker_write"`
	BeylaUprobeSaramaResponsePromiseHandle         *ebpf.Program `ebpf:"beyla_uprobe_sarama_response_promise_handle"`
	BeylaUprobeSaramaSendInternal                  *ebpf.Program `ebpf:"beyla_uprobe_sarama_sendInternal"`
	BeylaUprobeServerHandleStream                  *ebpf.Program `ebpf:"beyla_uprobe_server_handleStream"`
	BeylaUprobeServerHandleStreamReturn            *ebpf.Program `ebpf:"beyla_uprobe_server_handleStream_return"`
	BeylaUprobeServerHandlerTransportHandleStreams *ebpf.Program `ebpf:"beyla_uprobe_server_handler_transport_handle_streams"`
	BeylaUprobeTransportHttp2ClientNewStream       *ebpf.Program `ebpf:"beyla_uprobe_transport_http2Client_NewStream"`
	BeylaUprobeTransportWriteStatus                *ebpf.Program `ebpf:"beyla_uprobe_transport_writeStatus"`
	BeylaUprobeWriteSubset                         *ebpf.Program `ebpf:"beyla_uprobe_writeSubset"`
	BeylaUprobeWriterProduce                       *ebpf.Program `ebpf:"beyla_uprobe_writer_produce"`
	BeylaUprobeWriterWriteMessages                 *ebpf.Program `ebpf:"beyla_uprobe_writer_write_messages"`
}

func (p *bpfPrograms) Close() error {
	return _BpfClose(
		p.BeylaUprobeClientConnClose,
		p.BeylaUprobeClientConnInvoke,
		p.BeylaUprobeClientConnInvokeReturn,
		p.BeylaUprobeClientConnNewStream,
		p.BeylaUprobeClientConnNewStreamReturn,
		p.BeylaUprobeServeHTTP,
		p.BeylaUprobeServeHTTPReturns,
		p.BeylaUprobeClientStreamRecvMsgReturn,
		p.BeylaUprobeClientRoundTrip,
		p.BeylaUprobeConnServe,
		p.BeylaUprobeConnServeRet,
		p.BeylaUprobeExecDC,
		p.BeylaUprobeGrpcFramerWriteHeaders,
		p.BeylaUprobeGrpcFramerWriteHeadersReturns,
		p.BeylaUprobeHttp2FramerWriteHeaders,
		p.BeylaUprobeHttp2FramerWriteHeadersReturns,
		p.BeylaUprobeHttp2ResponseWriterStateWriteHeader,
		p.BeylaUprobeHttp2RoundTrip,
		p.BeylaUprobeHttp2RoundTripConn,
		p.BeylaUprobeHttp2ServerOperateHeaders,
		p.BeylaUprobeHttp2ServerProcessHeaders,
		p.BeylaUprobeHttp2serverConnRunHandler,
		p.BeylaUprobeNetFdRead,
		p.BeylaUprobePersistConnRoundTrip,
		p.BeylaUprobeProcGoexit1,
		p.BeylaUprobeProcNewproc1,
		p.BeylaUprobeProcNewproc1Ret,
		p.BeylaUprobeProtocolRoundtrip,
		p.BeylaUprobeProtocolRoundtripRet,
		p.BeylaUprobeQueryDC,
		p.BeylaUprobeQueryReturn,
		p.BeylaUprobeReadContinuedLineSliceReturns,
		p.BeylaUprobeReadRequestReturns,
		p.BeylaUprobeReadRequestStart,
		p.BeylaUprobeReaderRead,
		p.BeylaUprobeReaderReadRet,
		p.BeylaUprobeReaderSendMessage,
		p.BeylaUprobeRedisProcess,
		p.BeylaUprobeRedisProcessRet,
		p.BeylaUprobeRedisWithWriter,
		p.BeylaUprobeRedisWithWriterRet,
		p.BeylaUprobeRoundTrip,
		p.BeylaUprobeRoundTripReturn,
		p.BeylaUprobeSaramaBrokerWrite,
		p.BeylaUprobeSaramaResponsePromiseHandle,
		p.BeylaUprobeSaramaSendInternal,
		p.BeylaUprobeServerHandleStream,
		p.BeylaUprobeServerHandleStreamReturn,
		p.BeylaUprobeServerHandlerTransportHandleStreams,
		p.BeylaUprobeTransportHttp2ClientNewStream,
		p.BeylaUprobeTransportWriteStatus,
		p.BeylaUprobeWriteSubset,
		p.BeylaUprobeWriterProduce,
		p.BeylaUprobeWriterWriteMessages,
	)
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_x86_bpfel.o
var _BpfBytes []byte
