// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilitySeverity The vulnerability severity.
type VulnerabilitySeverity string

// List of VulnerabilitySeverity.
const (
	VULNERABILITYSEVERITY_UNKNOWN  VulnerabilitySeverity = "Unknown"
	VULNERABILITYSEVERITY_NONE     VulnerabilitySeverity = "None"
	VULNERABILITYSEVERITY_LOW      VulnerabilitySeverity = "Low"
	VULNERABILITYSEVERITY_MEDIUM   VulnerabilitySeverity = "Medium"
	VULNERABILITYSEVERITY_HIGH     VulnerabilitySeverity = "High"
	VULNERABILITYSEVERITY_CRITICAL VulnerabilitySeverity = "Critical"
)

var allowedVulnerabilitySeverityEnumValues = []VulnerabilitySeverity{
	VULNERABILITYSEVERITY_UNKNOWN,
	VULNERABILITYSEVERITY_NONE,
	VULNERABILITYSEVERITY_LOW,
	VULNERABILITYSEVERITY_MEDIUM,
	VULNERABILITYSEVERITY_HIGH,
	VULNERABILITYSEVERITY_CRITICAL,
}

// GetAllowedValues reeturns the list of possible values.
func (v *VulnerabilitySeverity) GetAllowedValues() []VulnerabilitySeverity {
	return allowedVulnerabilitySeverityEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *VulnerabilitySeverity) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = VulnerabilitySeverity(value)
	return nil
}

// NewVulnerabilitySeverityFromValue returns a pointer to a valid VulnerabilitySeverity
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewVulnerabilitySeverityFromValue(v string) (*VulnerabilitySeverity, error) {
	ev := VulnerabilitySeverity(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for VulnerabilitySeverity: valid values are %v", v, allowedVulnerabilitySeverityEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v VulnerabilitySeverity) IsValid() bool {
	for _, existing := range allowedVulnerabilitySeverityEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to VulnerabilitySeverity value.
func (v VulnerabilitySeverity) Ptr() *VulnerabilitySeverity {
	return &v
}
