// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV1

import (
	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// HostMuteResponse Response with the list of muted host for your organization.
type HostMuteResponse struct {
	// Action applied to the hosts.
	Action *string `json:"action,omitempty"`
	// POSIX timestamp in seconds when the host is unmuted.
	End *int64 `json:"end,omitempty"`
	// The host name.
	Hostname *string `json:"hostname,omitempty"`
	// Message associated with the mute.
	Message *string `json:"message,omitempty"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewHostMuteResponse instantiates a new HostMuteResponse object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewHostMuteResponse() *HostMuteResponse {
	this := HostMuteResponse{}
	return &this
}

// NewHostMuteResponseWithDefaults instantiates a new HostMuteResponse object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewHostMuteResponseWithDefaults() *HostMuteResponse {
	this := HostMuteResponse{}
	return &this
}

// GetAction returns the Action field value if set, zero value otherwise.
func (o *HostMuteResponse) GetAction() string {
	if o == nil || o.Action == nil {
		var ret string
		return ret
	}
	return *o.Action
}

// GetActionOk returns a tuple with the Action field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *HostMuteResponse) GetActionOk() (*string, bool) {
	if o == nil || o.Action == nil {
		return nil, false
	}
	return o.Action, true
}

// HasAction returns a boolean if a field has been set.
func (o *HostMuteResponse) HasAction() bool {
	return o != nil && o.Action != nil
}

// SetAction gets a reference to the given string and assigns it to the Action field.
func (o *HostMuteResponse) SetAction(v string) {
	o.Action = &v
}

// GetEnd returns the End field value if set, zero value otherwise.
func (o *HostMuteResponse) GetEnd() int64 {
	if o == nil || o.End == nil {
		var ret int64
		return ret
	}
	return *o.End
}

// GetEndOk returns a tuple with the End field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *HostMuteResponse) GetEndOk() (*int64, bool) {
	if o == nil || o.End == nil {
		return nil, false
	}
	return o.End, true
}

// HasEnd returns a boolean if a field has been set.
func (o *HostMuteResponse) HasEnd() bool {
	return o != nil && o.End != nil
}

// SetEnd gets a reference to the given int64 and assigns it to the End field.
func (o *HostMuteResponse) SetEnd(v int64) {
	o.End = &v
}

// GetHostname returns the Hostname field value if set, zero value otherwise.
func (o *HostMuteResponse) GetHostname() string {
	if o == nil || o.Hostname == nil {
		var ret string
		return ret
	}
	return *o.Hostname
}

// GetHostnameOk returns a tuple with the Hostname field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *HostMuteResponse) GetHostnameOk() (*string, bool) {
	if o == nil || o.Hostname == nil {
		return nil, false
	}
	return o.Hostname, true
}

// HasHostname returns a boolean if a field has been set.
func (o *HostMuteResponse) HasHostname() bool {
	return o != nil && o.Hostname != nil
}

// SetHostname gets a reference to the given string and assigns it to the Hostname field.
func (o *HostMuteResponse) SetHostname(v string) {
	o.Hostname = &v
}

// GetMessage returns the Message field value if set, zero value otherwise.
func (o *HostMuteResponse) GetMessage() string {
	if o == nil || o.Message == nil {
		var ret string
		return ret
	}
	return *o.Message
}

// GetMessageOk returns a tuple with the Message field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *HostMuteResponse) GetMessageOk() (*string, bool) {
	if o == nil || o.Message == nil {
		return nil, false
	}
	return o.Message, true
}

// HasMessage returns a boolean if a field has been set.
func (o *HostMuteResponse) HasMessage() bool {
	return o != nil && o.Message != nil
}

// SetMessage gets a reference to the given string and assigns it to the Message field.
func (o *HostMuteResponse) SetMessage(v string) {
	o.Message = &v
}

// MarshalJSON serializes the struct using spec logic.
func (o HostMuteResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	if o.Action != nil {
		toSerialize["action"] = o.Action
	}
	if o.End != nil {
		toSerialize["end"] = o.End
	}
	if o.Hostname != nil {
		toSerialize["hostname"] = o.Hostname
	}
	if o.Message != nil {
		toSerialize["message"] = o.Message
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *HostMuteResponse) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		Action   *string `json:"action,omitempty"`
		End      *int64  `json:"end,omitempty"`
		Hostname *string `json:"hostname,omitempty"`
		Message  *string `json:"message,omitempty"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"action", "end", "hostname", "message"})
	} else {
		return err
	}
	o.Action = all.Action
	o.End = all.End
	o.Hostname = all.Hostname
	o.Message = all.Message

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	return nil
}
