//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// OperationsForMonitorClient contains the methods for the OperationsForMonitor group.
// Don't use this type directly, use NewOperationsForMonitorClient() instead.
type OperationsForMonitorClient struct {
	internal *arm.Client
}

// NewOperationsForMonitorClient creates a new instance of OperationsForMonitorClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewOperationsForMonitorClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*OperationsForMonitorClient, error) {
	cl, err := arm.NewClient(moduleName+".OperationsForMonitorClient", moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &OperationsForMonitorClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Lists available Operations for this Resource Provider
//
// Generated from API version 2021-06-03-preview
//   - options - OperationsForMonitorClientListOptions contains the optional parameters for the OperationsForMonitorClient.NewListPager
//     method.
func (client *OperationsForMonitorClient) NewListPager(options *OperationsForMonitorClientListOptions) *runtime.Pager[OperationsForMonitorClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[OperationsForMonitorClientListResponse]{
		More: func(page OperationsForMonitorClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *OperationsForMonitorClientListResponse) (OperationsForMonitorClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "OperationsForMonitorClient.NewListPager")
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return OperationsForMonitorClientListResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return OperationsForMonitorClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return OperationsForMonitorClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *OperationsForMonitorClient) listCreateRequest(ctx context.Context, options *OperationsForMonitorClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Monitor/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-03-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *OperationsForMonitorClient) listHandleResponse(resp *http.Response) (OperationsForMonitorClientListResponse, error) {
	result := OperationsForMonitorClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationListResultAutoGenerated); err != nil {
		return OperationsForMonitorClientListResponse{}, err
	}
	return result, nil
}
