"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _createSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/createSuper"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classnames = _interopRequireDefault(require("classnames"));
var _pickAttrs = _interopRequireDefault(require("rc-util/lib/pickAttrs"));
var React = _interopRequireWildcard(require("react"));
var _contextTypes = require("./contextTypes");
var _Indent = _interopRequireDefault(require("./Indent"));
var _keyUtil = _interopRequireDefault(require("./utils/keyUtil"));
var _treeUtil = require("./utils/treeUtil");
var _excluded = ["eventKey", "className", "style", "dragOver", "dragOverGapTop", "dragOverGapBottom", "isLeaf", "isStart", "isEnd", "expanded", "selected", "checked", "halfChecked", "loading", "domRef", "active", "data", "onMouseMove", "selectable"]; // @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ICON_OPEN = 'open';
var ICON_CLOSE = 'close';
var defaultTitle = '---';
var InternalTreeNode = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(InternalTreeNode, _React$Component);
  var _super = (0, _createSuper2.default)(InternalTreeNode);
  function InternalTreeNode() {
    var _this;
    (0, _classCallCheck2.default)(this, InternalTreeNode);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      dragNodeHighlight: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "selectHandle", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "cacheIndent", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSelectorClick", function (e) {
      // Click trigger before select/check operation
      var onNodeClick = _this.props.context.onNodeClick;
      onNodeClick(e, (0, _treeUtil.convertNodePropsToEventData)(_this.props));
      if (_this.isSelectable()) {
        _this.onSelect(e);
      } else {
        _this.onCheck(e);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSelectorDoubleClick", function (e) {
      var onNodeDoubleClick = _this.props.context.onNodeDoubleClick;
      onNodeDoubleClick(e, (0, _treeUtil.convertNodePropsToEventData)(_this.props));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSelect", function (e) {
      if (_this.isDisabled()) return;
      var onNodeSelect = _this.props.context.onNodeSelect;
      onNodeSelect(e, (0, _treeUtil.convertNodePropsToEventData)(_this.props));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCheck", function (e) {
      if (_this.isDisabled()) return;
      var _this$props = _this.props,
        disableCheckbox = _this$props.disableCheckbox,
        checked = _this$props.checked;
      var onNodeCheck = _this.props.context.onNodeCheck;
      if (!_this.isCheckable() || disableCheckbox) return;
      var targetChecked = !checked;
      onNodeCheck(e, (0, _treeUtil.convertNodePropsToEventData)(_this.props), targetChecked);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMouseEnter", function (e) {
      var onNodeMouseEnter = _this.props.context.onNodeMouseEnter;
      onNodeMouseEnter(e, (0, _treeUtil.convertNodePropsToEventData)(_this.props));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMouseLeave", function (e) {
      var onNodeMouseLeave = _this.props.context.onNodeMouseLeave;
      onNodeMouseLeave(e, (0, _treeUtil.convertNodePropsToEventData)(_this.props));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onContextMenu", function (e) {
      var onNodeContextMenu = _this.props.context.onNodeContextMenu;
      onNodeContextMenu(e, (0, _treeUtil.convertNodePropsToEventData)(_this.props));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDragStart", function (e) {
      var onNodeDragStart = _this.props.context.onNodeDragStart;
      e.stopPropagation();
      _this.setState({
        dragNodeHighlight: true
      });
      onNodeDragStart(e, (0, _assertThisInitialized2.default)(_this));
      try {
        // ie throw error
        // firefox-need-it
        e.dataTransfer.setData('text/plain', '');
      } catch (error) {
        // empty
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDragEnter", function (e) {
      var onNodeDragEnter = _this.props.context.onNodeDragEnter;
      e.preventDefault();
      e.stopPropagation();
      onNodeDragEnter(e, (0, _assertThisInitialized2.default)(_this));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDragOver", function (e) {
      var onNodeDragOver = _this.props.context.onNodeDragOver;
      e.preventDefault();
      e.stopPropagation();
      onNodeDragOver(e, (0, _assertThisInitialized2.default)(_this));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDragLeave", function (e) {
      var onNodeDragLeave = _this.props.context.onNodeDragLeave;
      e.stopPropagation();
      onNodeDragLeave(e, (0, _assertThisInitialized2.default)(_this));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDragEnd", function (e) {
      var onNodeDragEnd = _this.props.context.onNodeDragEnd;
      e.stopPropagation();
      _this.setState({
        dragNodeHighlight: false
      });
      onNodeDragEnd(e, (0, _assertThisInitialized2.default)(_this));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDrop", function (e) {
      var onNodeDrop = _this.props.context.onNodeDrop;
      e.preventDefault();
      e.stopPropagation();
      _this.setState({
        dragNodeHighlight: false
      });
      onNodeDrop(e, (0, _assertThisInitialized2.default)(_this));
    });
    // Disabled item still can be switch
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onExpand", function (e) {
      var _this$props2 = _this.props,
        loading = _this$props2.loading,
        onNodeExpand = _this$props2.context.onNodeExpand;
      if (loading) return;
      onNodeExpand(e, (0, _treeUtil.convertNodePropsToEventData)(_this.props));
    });
    // Drag usage
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setSelectHandle", function (node) {
      _this.selectHandle = node;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getNodeState", function () {
      var expanded = _this.props.expanded;
      if (_this.isLeaf()) {
        return null;
      }
      return expanded ? ICON_OPEN : ICON_CLOSE;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "hasChildren", function () {
      var eventKey = _this.props.eventKey;
      var keyEntities = _this.props.context.keyEntities;
      var _ref = (0, _keyUtil.default)(keyEntities, eventKey) || {},
        children = _ref.children;
      return !!(children || []).length;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isLeaf", function () {
      var _this$props3 = _this.props,
        isLeaf = _this$props3.isLeaf,
        loaded = _this$props3.loaded;
      var loadData = _this.props.context.loadData;
      var hasChildren = _this.hasChildren();
      if (isLeaf === false) {
        return false;
      }
      return isLeaf || !loadData && !hasChildren || loadData && loaded && !hasChildren;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isDisabled", function () {
      var _this$props4 = _this.props,
        disabled = _this$props4.disabled,
        data = _this$props4.data;
      var _this$props5 = _this.props,
        treeDisabled = _this$props5.context.disabled,
        nodeDisabled = _this$props5.unstableContext.nodeDisabled;
      return !!(treeDisabled || disabled || nodeDisabled && nodeDisabled(data));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isCheckable", function () {
      var checkable = _this.props.checkable;
      var treeCheckable = _this.props.context.checkable;

      // Return false if tree or treeNode is not checkable
      if (!treeCheckable || checkable === false) return false;
      return treeCheckable;
    });
    // Load data to avoid default expanded tree without data
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "syncLoadData", function (props) {
      var expanded = props.expanded,
        loading = props.loading,
        loaded = props.loaded;
      var _this$props$context = _this.props.context,
        loadData = _this$props$context.loadData,
        onNodeLoad = _this$props$context.onNodeLoad;
      if (loading) {
        return;
      }

      // read from state to avoid loadData at same time
      if (loadData && expanded && !_this.isLeaf() && !loaded) {
        // We needn't reload data when has children in sync logic
        // It's only needed in node expanded
        onNodeLoad((0, _treeUtil.convertNodePropsToEventData)(_this.props));
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isDraggable", function () {
      var _this$props6 = _this.props,
        data = _this$props6.data,
        draggable = _this$props6.context.draggable;
      return !!(draggable && (!draggable.nodeDraggable || draggable.nodeDraggable(data)));
    });
    // ==================== Render: Drag Handler ====================
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderDragHandler", function () {
      var _this$props$context2 = _this.props.context,
        draggable = _this$props$context2.draggable,
        prefixCls = _this$props$context2.prefixCls;
      return draggable !== null && draggable !== void 0 && draggable.icon ? /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefixCls, "-draggable-icon")
      }, draggable.icon) : null;
    });
    // ====================== Render: Switcher ======================
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderSwitcherIconDom", function (isLeaf) {
      var switcherIconFromProps = _this.props.switcherIcon;
      var switcherIconFromCtx = _this.props.context.switcherIcon;
      var switcherIcon = switcherIconFromProps || switcherIconFromCtx;
      // if switcherIconDom is null, no render switcher span
      if (typeof switcherIcon === 'function') {
        return switcherIcon((0, _objectSpread2.default)((0, _objectSpread2.default)({}, _this.props), {}, {
          isLeaf: isLeaf
        }));
      }
      return switcherIcon;
    });
    // Switcher
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderSwitcher", function () {
      var expanded = _this.props.expanded;
      var prefixCls = _this.props.context.prefixCls;
      if (_this.isLeaf()) {
        // if switcherIconDom is null, no render switcher span
        var _switcherIconDom = _this.renderSwitcherIconDom(true);
        return _switcherIconDom !== false ? /*#__PURE__*/React.createElement("span", {
          className: (0, _classnames.default)("".concat(prefixCls, "-switcher"), "".concat(prefixCls, "-switcher-noop"))
        }, _switcherIconDom) : null;
      }
      var switcherCls = (0, _classnames.default)("".concat(prefixCls, "-switcher"), "".concat(prefixCls, "-switcher_").concat(expanded ? ICON_OPEN : ICON_CLOSE));
      var switcherIconDom = _this.renderSwitcherIconDom(false);
      return switcherIconDom !== false ? /*#__PURE__*/React.createElement("span", {
        onClick: _this.onExpand,
        className: switcherCls
      }, switcherIconDom) : null;
    });
    // ====================== Render: Checkbox ======================
    // Checkbox
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderCheckbox", function () {
      var _this$props7 = _this.props,
        checked = _this$props7.checked,
        halfChecked = _this$props7.halfChecked,
        disableCheckbox = _this$props7.disableCheckbox,
        title = _this$props7.title;
      var prefixCls = _this.props.context.prefixCls;
      var disabled = _this.isDisabled();
      var checkable = _this.isCheckable();
      if (!checkable) return null;

      // [Legacy] Custom element should be separate with `checkable` in future
      var $custom = typeof checkable !== 'boolean' ? checkable : null;
      return /*#__PURE__*/React.createElement("span", {
        className: (0, _classnames.default)("".concat(prefixCls, "-checkbox"), checked && "".concat(prefixCls, "-checkbox-checked"), !checked && halfChecked && "".concat(prefixCls, "-checkbox-indeterminate"), (disabled || disableCheckbox) && "".concat(prefixCls, "-checkbox-disabled")),
        onClick: _this.onCheck,
        role: "checkbox",
        "aria-checked": halfChecked ? 'mixed' : checked,
        "aria-disabled": disabled || disableCheckbox,
        "aria-label": "Select ".concat(typeof title === 'string' ? title : 'tree node')
      }, $custom);
    });
    // ==================== Render: Title + Icon ====================
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderIcon", function () {
      var loading = _this.props.loading;
      var prefixCls = _this.props.context.prefixCls;
      return /*#__PURE__*/React.createElement("span", {
        className: (0, _classnames.default)("".concat(prefixCls, "-iconEle"), "".concat(prefixCls, "-icon__").concat(_this.getNodeState() || 'docu'), loading && "".concat(prefixCls, "-icon_loading"))
      });
    });
    // Icon + Title
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderSelector", function () {
      var dragNodeHighlight = _this.state.dragNodeHighlight;
      var _this$props8 = _this.props,
        _this$props8$title = _this$props8.title,
        title = _this$props8$title === void 0 ? defaultTitle : _this$props8$title,
        selected = _this$props8.selected,
        icon = _this$props8.icon,
        loading = _this$props8.loading,
        data = _this$props8.data;
      var _this$props$context3 = _this.props.context,
        prefixCls = _this$props$context3.prefixCls,
        showIcon = _this$props$context3.showIcon,
        treeIcon = _this$props$context3.icon,
        loadData = _this$props$context3.loadData,
        titleRender = _this$props$context3.titleRender;
      var disabled = _this.isDisabled();
      var wrapClass = "".concat(prefixCls, "-node-content-wrapper");

      // Icon - Still show loading icon when loading without showIcon
      var $icon;
      if (showIcon) {
        var currentIcon = icon || treeIcon;
        $icon = currentIcon ? /*#__PURE__*/React.createElement("span", {
          className: (0, _classnames.default)("".concat(prefixCls, "-iconEle"), "".concat(prefixCls, "-icon__customize"))
        }, typeof currentIcon === 'function' ? currentIcon(_this.props) : currentIcon) : _this.renderIcon();
      } else if (loadData && loading) {
        $icon = _this.renderIcon();
      }

      // Title
      var titleNode;
      if (typeof title === 'function') {
        titleNode = title(data);
      } else if (titleRender) {
        titleNode = titleRender(data);
      } else {
        titleNode = title;
      }
      var $title = /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefixCls, "-title")
      }, titleNode);
      return /*#__PURE__*/React.createElement("span", {
        ref: _this.setSelectHandle,
        title: typeof title === 'string' ? title : '',
        className: (0, _classnames.default)("".concat(wrapClass), "".concat(wrapClass, "-").concat(_this.getNodeState() || 'normal'), !disabled && (selected || dragNodeHighlight) && "".concat(prefixCls, "-node-selected")),
        onMouseEnter: _this.onMouseEnter,
        onMouseLeave: _this.onMouseLeave,
        onContextMenu: _this.onContextMenu,
        onClick: _this.onSelectorClick,
        onDoubleClick: _this.onSelectorDoubleClick
      }, $icon, $title, _this.renderDropIndicator());
    });
    // =================== Render: Drop Indicator ===================
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderDropIndicator", function () {
      var _this$props9 = _this.props,
        disabled = _this$props9.disabled,
        eventKey = _this$props9.eventKey;
      var _this$props$context4 = _this.props.context,
        draggable = _this$props$context4.draggable,
        dropLevelOffset = _this$props$context4.dropLevelOffset,
        dropPosition = _this$props$context4.dropPosition,
        prefixCls = _this$props$context4.prefixCls,
        indent = _this$props$context4.indent,
        dropIndicatorRender = _this$props$context4.dropIndicatorRender,
        dragOverNodeKey = _this$props$context4.dragOverNodeKey,
        direction = _this$props$context4.direction;
      var rootDraggable = !!draggable;
      // allowDrop is calculated in Tree.tsx, there is no need for calc it here
      var showIndicator = !disabled && rootDraggable && dragOverNodeKey === eventKey;

      // This is a hot fix which is already fixed in
      // https://github.com/react-component/tree/pull/743/files
      // But some case need break point so we hack on this
      // ref https://github.com/ant-design/ant-design/issues/43493
      var mergedIndent = indent !== null && indent !== void 0 ? indent : _this.cacheIndent;
      _this.cacheIndent = indent;
      return showIndicator ? dropIndicatorRender({
        dropPosition: dropPosition,
        dropLevelOffset: dropLevelOffset,
        indent: mergedIndent,
        prefixCls: prefixCls,
        direction: direction
      }) : null;
    });
    return _this;
  }
  (0, _createClass2.default)(InternalTreeNode, [{
    key: "componentDidMount",
    value:
    // Isomorphic needn't load data in server side
    function componentDidMount() {
      this.syncLoadData(this.props);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.syncLoadData(this.props);
    }
  }, {
    key: "isSelectable",
    value: function isSelectable() {
      var selectable = this.props.selectable;
      var treeSelectable = this.props.context.selectable;

      // Ignore when selectable is undefined or null
      if (typeof selectable === 'boolean') {
        return selectable;
      }
      return treeSelectable;
    }
  }, {
    key: "render",
    value:
    // =========================== Render ===========================
    function render() {
      var _classNames;
      var _this$props10 = this.props,
        eventKey = _this$props10.eventKey,
        className = _this$props10.className,
        style = _this$props10.style,
        dragOver = _this$props10.dragOver,
        dragOverGapTop = _this$props10.dragOverGapTop,
        dragOverGapBottom = _this$props10.dragOverGapBottom,
        isLeaf = _this$props10.isLeaf,
        isStart = _this$props10.isStart,
        isEnd = _this$props10.isEnd,
        expanded = _this$props10.expanded,
        selected = _this$props10.selected,
        checked = _this$props10.checked,
        halfChecked = _this$props10.halfChecked,
        loading = _this$props10.loading,
        domRef = _this$props10.domRef,
        active = _this$props10.active,
        data = _this$props10.data,
        onMouseMove = _this$props10.onMouseMove,
        selectable = _this$props10.selectable,
        otherProps = (0, _objectWithoutProperties2.default)(_this$props10, _excluded);
      var _this$props$context5 = this.props.context,
        prefixCls = _this$props$context5.prefixCls,
        filterTreeNode = _this$props$context5.filterTreeNode,
        keyEntities = _this$props$context5.keyEntities,
        dropContainerKey = _this$props$context5.dropContainerKey,
        dropTargetKey = _this$props$context5.dropTargetKey,
        draggingNodeKey = _this$props$context5.draggingNodeKey;
      var disabled = this.isDisabled();
      var dataOrAriaAttributeProps = (0, _pickAttrs.default)(otherProps, {
        aria: true,
        data: true
      });
      var _ref2 = (0, _keyUtil.default)(keyEntities, eventKey) || {},
        level = _ref2.level;
      var isEndNode = isEnd[isEnd.length - 1];
      var mergedDraggable = this.isDraggable();
      var draggableWithoutDisabled = !disabled && mergedDraggable;
      var dragging = draggingNodeKey === eventKey;
      var ariaSelected = selectable !== undefined ? {
        'aria-selected': !!selectable
      } : undefined;
      return /*#__PURE__*/React.createElement("div", (0, _extends2.default)({
        ref: domRef,
        role: "treeitem",
        "aria-expanded": isLeaf ? undefined : expanded,
        className: (0, _classnames.default)(className, "".concat(prefixCls, "-treenode"), (_classNames = {}, (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-treenode-disabled"), disabled), "".concat(prefixCls, "-treenode-switcher-").concat(expanded ? 'open' : 'close'), !isLeaf), "".concat(prefixCls, "-treenode-checkbox-checked"), checked), "".concat(prefixCls, "-treenode-checkbox-indeterminate"), halfChecked), "".concat(prefixCls, "-treenode-selected"), selected), "".concat(prefixCls, "-treenode-loading"), loading), "".concat(prefixCls, "-treenode-active"), active), "".concat(prefixCls, "-treenode-leaf-last"), isEndNode), "".concat(prefixCls, "-treenode-draggable"), mergedDraggable), "dragging", dragging), (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)(_classNames, 'drop-target', dropTargetKey === eventKey), 'drop-container', dropContainerKey === eventKey), 'drag-over', !disabled && dragOver), 'drag-over-gap-top', !disabled && dragOverGapTop), 'drag-over-gap-bottom', !disabled && dragOverGapBottom), 'filter-node', filterTreeNode && filterTreeNode((0, _treeUtil.convertNodePropsToEventData)(this.props))))),
        style: style
        // Draggable config
        ,
        draggable: draggableWithoutDisabled,
        onDragStart: draggableWithoutDisabled ? this.onDragStart : undefined
        // Drop config
        ,
        onDragEnter: mergedDraggable ? this.onDragEnter : undefined,
        onDragOver: mergedDraggable ? this.onDragOver : undefined,
        onDragLeave: mergedDraggable ? this.onDragLeave : undefined,
        onDrop: mergedDraggable ? this.onDrop : undefined,
        onDragEnd: mergedDraggable ? this.onDragEnd : undefined,
        onMouseMove: onMouseMove
      }, ariaSelected, dataOrAriaAttributeProps), /*#__PURE__*/React.createElement(_Indent.default, {
        prefixCls: prefixCls,
        level: level,
        isStart: isStart,
        isEnd: isEnd
      }), this.renderDragHandler(), this.renderSwitcher(), this.renderCheckbox(), this.renderSelector());
    }
  }]);
  return InternalTreeNode;
}(React.Component);
var ContextTreeNode = function ContextTreeNode(props) {
  return /*#__PURE__*/React.createElement(_contextTypes.TreeContext.Consumer, null, function (context) {
    return /*#__PURE__*/React.createElement(_contextTypes.UnstableContext.Consumer, null, function (unstableContext) {
      return /*#__PURE__*/React.createElement(InternalTreeNode, (0, _extends2.default)({}, props, {
        context: context,
        unstableContext: unstableContext
      }));
    });
  });
};
ContextTreeNode.displayName = 'TreeNode';
ContextTreeNode.isTreeNode = 1;
var _default = exports.default = ContextTreeNode;