/**
 * General utilities for use throughout the package
 *
 * @packageDocumentation
 */
/** utility type for replacing keys with new value */
export declare type Up<O, N> = Omit<O, keyof N> & N;
/** assert something */
export declare function assert(statement: unknown): asserts statement;
/** determines if two sets are equal */
export declare function setEqual<T>(first: Set<T>, second: Set<T>): boolean;
/** determines if two sets intersect */
export declare function setIntersect<T>(first: Set<T>, second: Set<T>): boolean;
/**
 * removes a single arbitrary element from the Set, or undefined is missing
 *
 * @remarks
 * if the set contains undefined, then this doesn't distinguish in output,
 * but will properly remove it.
 */
export declare function setPop<T>(elems: Set<T>): T | undefined;
/**
 * push val onto key list for multimap
 */
export declare function listMultimapPush<K, V>(multimap: Map<K, V[]>, key: K, val: V): void;
/**
 * add val to key set for multimap
 */
export declare function setMultimapAdd<K, V>(multimap: Map<K, Set<V>>, key: K, val: V): void;
/** a generic json replacer */
export interface Replacer {
    (key: string, value: unknown): unknown;
}
/** replacer for serializing possibly circular json */
export declare function getCircularReplacer(): Replacer;
/** format tag for converting inputs to json */
export declare function js(strings: TemplateStringsArray, ...values: unknown[]): string;
/** iterate over bigrams of an array */
export declare function bigrams<T>(array: readonly T[]): IterableIterator<[T, T]>;
/** a callback for things with children */
export interface ChildrenCallback<T> {
    (node: T): Iterable<T>;
}
/** depth first search for arbitrary types */
export declare function dfs<T>(children: ChildrenCallback<T>, ...queue: T[]): IterableIterator<T>;
