/**
 * Create a {@link CenterOperator}. Bundled as {@link coordCenter}.
 */
export function center(...args) {
    if (args.length) {
        throw new Error(`got arguments to center(${args}), but constructor takes no arguments.`);
    }
    function centerCall(layers, nodeSize) {
        const widths = layers.map((layer) => {
            let width = 0;
            for (const node of layer) {
                const nodeWidth = nodeSize(node);
                node.x = width + nodeWidth / 2;
                width += nodeWidth;
            }
            return width;
        });
        const maxWidth = Math.max(...widths);
        if (maxWidth <= 0) {
            throw new Error("must assign nonzero width to at least one node");
        }
        for (const [i, layer] of layers.entries()) {
            const width = widths[i];
            const offset = (maxWidth - width) / 2;
            for (const node of layer) {
                node.x += offset;
            }
        }
        return maxWidth;
    }
    return centerCall;
}
