import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.js';
import { TimePickerButtonLabel } from '../TimeRangePicker.js';
import { isValidTimeRange } from '../utils.js';

const TimeRangeLabel = memo(function TimePickerLabel({
  hideText,
  value,
  timeZone = "browser",
  placeholder = "No time range selected",
  className
}) {
  const styles = useStyles2(getLabelStyles);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ jsx("span", { className, children: isValidTimeRange(value) ? /* @__PURE__ */ jsx(TimePickerButtonLabel, { value, timeZone }) : /* @__PURE__ */ jsx("span", { className: styles.placeholder, children: placeholder }) });
});
const getLabelStyles = (theme) => {
  return {
    placeholder: css({
      color: theme.colors.text.disabled,
      opacity: 1
    })
  };
};

export { TimeRangeLabel };
//# sourceMappingURL=TimeRangeLabel.js.map
