import * as raw from '../common/common.gen';
import { MatcherConfig } from './dashboard.types';
export interface MapLayerOptions<TConfig = any> extends raw.MapLayerOptions {
    config?: TConfig;
    filterData?: MatcherConfig;
}
export interface DataQuery extends raw.DataQuery {
    /**
     * Unique, guid like, string (used only in explore mode)
     */
    key?: string;
    datasource?: raw.DataSourceRef | null;
}
export interface BaseDimensionConfig<T = string | number> extends Omit<raw.BaseDimensionConfig, 'fixed'> {
    fixed: T;
}
export interface ScaleDimensionConfig extends BaseDimensionConfig<number>, Omit<raw.ScaleDimensionConfig, 'fixed'> {
}
export interface ScalarDimensionConfig extends BaseDimensionConfig<number>, Omit<raw.ScalarDimensionConfig, 'fixed'> {
}
export interface TextDimensionConfig extends BaseDimensionConfig<string>, Omit<raw.TextDimensionConfig, 'fixed'> {
}
export interface ColorDimensionConfig extends BaseDimensionConfig<string>, Omit<raw.ColorDimensionConfig, 'fixed'> {
}
export interface ColorDimensionConfig extends BaseDimensionConfig<string>, Omit<raw.ColorDimensionConfig, 'fixed'> {
}
export interface ResourceDimensionConfig extends BaseDimensionConfig<string>, Omit<raw.ResourceDimensionConfig, 'fixed'> {
}
export * from '../common/common.gen';
export declare const defaultTableFieldOptions: raw.TableFieldOptions;
/**
 * Represent panel data loading state.
 * @deprecated Please use LoadingState from @grafana/data
 */
export declare enum LoadingState {
    NotStarted = "NotStarted",
    Loading = "Loading",
    Streaming = "Streaming",
    Done = "Done",
    Error = "Error"
}
