"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeMeasurementsAPI = void 0;
var transports_1 = require("../../transports");
var utils_1 = require("../../utils");
var date_1 = require("../../utils/date");
function initializeMeasurementsAPI(_unpatchedConsole, internalLogger, config, metas, transports, tracesApi) {
    internalLogger.debug('Initializing measurements API');
    var lastPayload = null;
    var pushMeasurement = function (payload, _a) {
        var _b = _a === void 0 ? {} : _a, skipDedupe = _b.skipDedupe, context = _b.context, spanContext = _b.spanContext, timestampOverwriteMs = _b.timestampOverwriteMs;
        try {
            var item = {
                type: transports_1.TransportItemType.MEASUREMENT,
                payload: __assign(__assign({}, payload), { trace: spanContext
                        ? {
                            trace_id: spanContext.traceId,
                            span_id: spanContext.spanId,
                        }
                        : tracesApi.getTraceContext(), timestamp: timestampOverwriteMs ? (0, date_1.timestampToIsoString)(timestampOverwriteMs) : (0, utils_1.getCurrentTimestamp)(), context: (0, utils_1.stringifyObjectValues)(context) }),
                meta: metas.value,
            };
            var testingPayload = {
                type: item.payload.type,
                values: item.payload.values,
                context: item.payload.context,
            };
            if (!skipDedupe && config.dedupe && !(0, utils_1.isNull)(lastPayload) && (0, utils_1.deepEqual)(testingPayload, lastPayload)) {
                internalLogger.debug('Skipping measurement push because it is the same as the last one\n', item.payload);
                return;
            }
            lastPayload = testingPayload;
            internalLogger.debug('Pushing measurement\n', item);
            transports.execute(item);
        }
        catch (err) {
            internalLogger.error('Error pushing measurement\n', err);
        }
    };
    return {
        pushMeasurement: pushMeasurement,
    };
}
exports.initializeMeasurementsAPI = initializeMeasurementsAPI;
//# sourceMappingURL=initialize.js.map