"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeEventsAPI = void 0;
var transports_1 = require("../../transports");
var utils_1 = require("../../utils");
var date_1 = require("../../utils/date");
function initializeEventsAPI(_unpatchedConsole, internalLogger, config, metas, transports, tracesApi) {
    var lastPayload = null;
    var pushEvent = function (name, attributes, domain, _a) {
        var _b = _a === void 0 ? {} : _a, skipDedupe = _b.skipDedupe, spanContext = _b.spanContext, timestampOverwriteMs = _b.timestampOverwriteMs;
        try {
            var item = {
                meta: metas.value,
                payload: {
                    name: name,
                    domain: domain !== null && domain !== void 0 ? domain : config.eventDomain,
                    attributes: (0, utils_1.stringifyObjectValues)(attributes),
                    timestamp: timestampOverwriteMs ? (0, date_1.timestampToIsoString)(timestampOverwriteMs) : (0, utils_1.getCurrentTimestamp)(),
                    trace: spanContext
                        ? {
                            trace_id: spanContext.traceId,
                            span_id: spanContext.spanId,
                        }
                        : tracesApi.getTraceContext(),
                },
                type: transports_1.TransportItemType.EVENT,
            };
            var testingPayload = {
                name: item.payload.name,
                attributes: item.payload.attributes,
                domain: item.payload.domain,
            };
            if (!skipDedupe && config.dedupe && !(0, utils_1.isNull)(lastPayload) && (0, utils_1.deepEqual)(testingPayload, lastPayload)) {
                internalLogger.debug('Skipping event push because it is the same as the last one\n', item.payload);
                return;
            }
            lastPayload = testingPayload;
            internalLogger.debug('Pushing event\n', item);
            transports.execute(item);
        }
        catch (err) {
            internalLogger.error('Error pushing event', err);
        }
    };
    return {
        pushEvent: pushEvent,
    };
}
exports.initializeEventsAPI = initializeEventsAPI;
//# sourceMappingURL=initialize.js.map