function nullToValue(frame) {
  return {
    ...frame,
    fields: frame.fields.map((field) => {
      const noValue = Number(field.config.noValue);
      if (!Number.isNaN(noValue)) {
        return nullToValueField(field, noValue);
      } else {
        return field;
      }
    })
  };
}
function nullToValueField(field, noValue) {
  const transformedVals = field.values.slice();
  for (let i = 0; i < transformedVals.length; i++) {
    if (transformedVals[i] === null) {
      transformedVals[i] = noValue;
    }
  }
  return {
    ...field,
    values: transformedVals
  };
}

export { nullToValue, nullToValueField };
//# sourceMappingURL=nullToValue.js.map
