# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## Generative AI (GenAI) Settings section


## Chatbot prompts
## Prompts are plain language ‘instructions’ sent to a chatbot.
## These prompts have been made concise and direct in English because some chatbot providers
## have character restrictions and being direct reduces the chance for misinterpretation.
## When localizing, please be concise and direct, but not at the expense of losing meaning.

# Prompt purpose: make a selection easier to read
genai-prompts-simplify =
    .label = ഭാഷ എളുപ്പമാക്കുക
    .value = തിരഞ്ഞെടുത്ത ഭാഗം ചെറുത വാക്യങ്ങളോടും വീണ്ടും എഴുതുക.

## Chatbot menu shortcuts

genai-menu-ask-generic =
    .label = നിൎമിതബുദ്ധി സല്ലാപയന്ത്രമനുഷ്യനെ ചോദിക്കുക
# $provider (string) - name of the provider
genai-menu-ask-provider =
    .label = { $provider }-നെ ചോദിക്കുക
genai-input-ask-generic =
    .placeholder = നിൎമിതബുദ്ധി സല്ലാപയന്ത്രമനുഷ്യനെ ചോദിക്കുക…

## Chatbot header

genai-header-provider-menu =
    .title = ഒരു സല്ലാപയന്ത്രമനുഷ്യനിനു് തിരഞ്ഞെടുക്കുക
genai-header-options-button =
    .title = കുറിപ്പടികട്ട തുറക്കുക
genai-header-close-button =
    .title = അടയ്ക്കുക
genai-options-show-shortcut =
    .label = എഴുത്തു് തിരഞ്ഞെടുക്കുമ്പോഴു് കുറുക്കുവഴി കാണിക്കുക
genai-options-hide-shortcut =
    .label = എഴുത്തു് തിരഞ്ഞെടുക്കുമ്പോഴു് കുറുക്കുവഴി മറയ്ക്കുക

## Chatbot footer


## Chatbot onboarding

genai-onboarding-primary = തുടരുക
genai-onboarding-secondary = അടയ്ക്കുക
genai-onboarding-claude-learn = ക്ലൗടിനെ പറ്റി കൂടുകലറിയുക
genai-onboarding-chatgpt-tooltip =
    .title = ചാറ്റുജിപിട്ടി
genai-onboarding-chatgpt-learn = ചാറ്റുജിപിട്ടിയെ പറ്റി കൂടുതലറിയുക
genai-onboarding-copilot-learn = കോപ്പൈലോട്ടിനെ പറ്റി കൂടുതലറിയുക
genai-onboarding-gemini-learn = ജെമിണിയെ പറ്റി കൂടുതലറിയുക
genai-onboarding-select-header = നിൎദ്ദേശങ്ങൾ കാണാൻ വേണ്ടി പാഠം തിരഞ്ഞെടുക്കുക
genai-onboarding-select-primary = നൎമ്മസല്ലാപം നടത്തുക

## Chatbot onboarding choices
## These describe features/capabilities of chatbot providers. These are not buttons/actions.

genai-onboarding-claude-generate = സങ്കേതവും വാചകവും ഉൽപാദിപ്പിക്കുക
genai-onboarding-claude-analyze = പ്രമാണങ്ങളുടെയും ചിത്രങ്ങളുടെയും വിശകലനം നടത്തുക
genai-onboarding-chatgpt-generate = സങ്കേതവും ചിത്രങ്ങളും വാചകവും ഉൽപാദിപ്പിക്കുക
genai-onboarding-chatgpt-analyze = പ്രമാണങ്ങളുടെയും ചിത്രങ്ങളുടെയും വിശകലനം നടത്തുക
genai-onboarding-copilot-generate = സങ്കേതവും ചിത്രങ്ങളും വാചകവും ഉൽപാദിപ്പിക്കുക
genai-onboarding-copilot-analyze = ചിത്രങ്ങളെ വിശകലിക്കുക
genai-onboarding-gemini-generate = സങ്കേതവും ചിത്രങ്ങളും വാചകവും ഉൽപാദിപ്പിക്കുക
genai-onboarding-gemini-analyze = ചിത്രങ്ങളും (സൗജന്യവും) രേഖകളും (പണമടച്ചത്) വിശകലിക്കുക
genai-onboarding-huggingchat-generate = സങ്കേതവും വാചകവും ഉൽപാദിപ്പിക്കുക
genai-onboarding-lechat-generate = സങ്കേതവും വാചകവും ഉൽപാദിപ്പിക്കുക
genai-onboarding-lechat-price = സൗജന്യം; അക്കൗണ്ട് ആവശ്യമാണു്

## Model Optin Component

genai-model-optin-continue =
    .label = തുടരുക
genai-model-optin-optout =
    .label = റദ്ദാക്കുക
genai-model-optin-cancel =
    .label = റദ്ദാക്കുക

## Link previews

