/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;

public class CSharp
extends MatchingTask {
    protected static final String csc_exe_name = "csc";
    protected static final String csc_file_ext = "cs";
    protected static final String csc_file_pattern = "*.cs";
    protected String _references;
    protected boolean _optimize;
    protected boolean _incremental;
    protected boolean _debug;
    protected File _docFile;
    private int _warnLevel;
    protected boolean _unsafe;
    protected String _mainClass;
    private File _srcDir;
    private File _destDir;
    protected String _targetType;
    protected File _win32icon;
    String _definitions;
    String _additionalModules;
    protected String _outputFile;
    protected boolean _failOnError;

    public CSharp() {
        this.Clear();
        this.setIncludes(csc_file_pattern);
    }

    public void Clear() {
        this._targetType = null;
        this._win32icon = null;
        this._srcDir = null;
        this._destDir = null;
        this._mainClass = null;
        this._unsafe = false;
        this._warnLevel = 3;
        this._docFile = null;
        this._incremental = false;
        this._optimize = false;
        this._debug = true;
        this._references = null;
        this._failOnError = true;
        this._definitions = null;
        this._additionalModules = null;
    }

    public void execute() throws BuildException {
        if (this._srcDir == null) {
            this._srcDir = this.project.resolveFile(".");
        }
        NetCommand command = new NetCommand(this, "CSC", csc_exe_name);
        command.setFailOnError(this.getFailFailOnError());
        command.setTraceCommandLine(true);
        command.addArgument("/nologo");
        command.addArgument(this.getAdditionalModulesParameter());
        command.addArgument(this.getDefinitionsParameter());
        command.addArgument(this.getDebugParameter());
        command.addArgument(this.getDocFileParameter());
        command.addArgument(this.getIncrementalParameter());
        command.addArgument(this.getMainClassParameter());
        command.addArgument(this.getOptimizeParameter());
        command.addArgument(this.getReferencesParameter());
        command.addArgument(this.getTargetTypeParameter());
        command.addArgument(this.getUnsafeParameter());
        command.addArgument(this.getWarnLevelParameter());
        command.addArgument(this.getWin32IconParameter());
        command.addArgument(this.getOutputFileParameter());
        DirectoryScanner scanner = super.getDirectoryScanner(this._srcDir);
        String[] dependencies = scanner.getIncludedFiles();
        this.log("compiling " + dependencies.length + " file" + (dependencies.length == 1 ? "" : "s"));
        String baseDir = scanner.getBasedir().toString();
        int i = 0;
        while (i < dependencies.length) {
            String targetFile = dependencies[i];
            targetFile = String.valueOf(baseDir) + File.separator + targetFile;
            command.addArgument(targetFile);
            ++i;
        }
        command.runCommand();
    }

    protected String getAdditionalModulesParameter() {
        if (this._additionalModules == null || this._additionalModules.length() == 0) {
            return null;
        }
        return "/addmodule:" + this._additionalModules;
    }

    public boolean getDebug() {
        return this._debug;
    }

    protected String getDebugParameter() {
        return "/debug" + (this._debug ? "+" : "-");
    }

    protected String getDefinitionsParameter() {
        if (this._definitions == null || this._definitions.length() == 0) {
            return null;
        }
        return "/DEFINE:" + this._definitions;
    }

    protected String getDocFileParameter() {
        if (this._docFile != null) {
            return "/doc:" + this._docFile.toString();
        }
        return null;
    }

    public boolean getFailFailOnError() {
        return this._failOnError;
    }

    public boolean getIncremental() {
        return this._incremental;
    }

    protected String getIncrementalParameter() {
        return "/incremental" + (this._incremental ? "+" : "-");
    }

    public String getMainClass() {
        return this._mainClass;
    }

    protected String getMainClassParameter() {
        if (this._mainClass != null && this._mainClass.length() != 0) {
            return "/main:" + this._mainClass;
        }
        return null;
    }

    public boolean getOptimize() {
        return this._optimize;
    }

    protected String getOptimizeParameter() {
        return "/optimize" + (this._optimize ? "+" : "-");
    }

    protected String getOutputFileParameter() {
        if (this._outputFile == null || this._outputFile.length() == 0) {
            return null;
        }
        File f = this.project.resolveFile(this._outputFile);
        return "/out:" + f.toString();
    }

    protected String getReferencesParameter() {
        if (this._references == null || this._references.length() == 0) {
            return null;
        }
        return "/reference:" + this._references;
    }

    public String getTargetType() {
        return this._targetType;
    }

    protected String getTargetTypeParameter() {
        if (this._targetType != null) {
            return "/target:" + this._targetType;
        }
        return null;
    }

    public boolean getUnsafe() {
        return this._unsafe;
    }

    protected String getUnsafeParameter() {
        return this._unsafe ? "/unsafe" : null;
    }

    public int getWarnLevel() {
        return this._warnLevel;
    }

    protected String getWarnLevelParameter() {
        return "/warn:" + this._warnLevel;
    }

    protected String getWin32IconParameter() {
        if (this._win32icon != null) {
            return "/win32icon:" + this._win32icon.toString();
        }
        return null;
    }

    public void setAdditionalModules(String params) {
        this._additionalModules = params;
    }

    public void setDebug(boolean f) {
        this._debug = f;
    }

    public void setDefinitions(String params) {
        this._definitions = params;
    }

    public void setDestDir(String dirName) {
        this._destDir = this.project.resolveFile(dirName);
    }

    public void setDocFile(String f) {
        this._docFile = this.project.resolveFile(f);
    }

    public void setFailOnError(boolean b) {
        this._failOnError = b;
    }

    public void setIncremental(boolean f) {
        this._incremental = f;
    }

    public void setMainClass(String mainClass) {
        this._mainClass = mainClass;
    }

    public void setOptimize(boolean f) {
        this._optimize = f;
    }

    public void setOutputFile(String params) {
        this._outputFile = params;
    }

    public void setReferences(String s) {
        this._references = s;
    }

    public void setSrcDir(String srcDirName) {
        this._srcDir = this.project.resolveFile(srcDirName);
    }

    public void setTargetType(String targetType) throws BuildException {
        if (!((targetType = targetType.toLowerCase()).equals("exe") || targetType.equals("library") || targetType.equals("module") || targetType.equals("winexe"))) {
            throw new BuildException("targetType " + targetType + " is not a valid type");
        }
        this._targetType = targetType;
    }

    public void setUnsafe(boolean unsafe) {
        this._unsafe = unsafe;
    }

    public void setWarnLevel(int warnLevel) {
        this._warnLevel = warnLevel;
    }

    public void setWin32Icon(String fileName) {
        this._win32icon = this.project.resolveFile(fileName);
    }
}

