/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;

public class Main {
    public static final String DEFAULT_BUILD_FILENAME = "build.xml";
    private int msgOutputLevel = 2;
    private File buildFile;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private Vector targets = new Vector(5);
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(5);
    private String loggerClassname = null;
    private boolean emacsMode = false;
    private boolean readyToRun = false;
    private boolean projectHelp = false;
    static /* synthetic */ Class class$org$apache$tools$ant$Main;

    protected Main(String[] args) throws BuildException {
        String searchForThis = null;
        int i = 0;
        while (i < args.length) {
            String msg;
            String arg = args[i];
            if (arg.equals("-help")) {
                Main.printUsage();
                return;
            }
            if (arg.equals("-version")) {
                Main.printVersion();
                return;
            }
            if (arg.equals("-quiet") || arg.equals("-q")) {
                this.msgOutputLevel = 1;
            } else if (arg.equals("-verbose") || arg.equals("-v")) {
                Main.printVersion();
                this.msgOutputLevel = 3;
            } else if (arg.equals("-debug")) {
                Main.printVersion();
                this.msgOutputLevel = 4;
            } else if (arg.equals("-logfile") || arg.equals("-l")) {
                try {
                    File logFile = new File(args[i + 1]);
                    ++i;
                    this.err = this.out = new PrintStream(new FileOutputStream(logFile));
                    System.setOut(this.out);
                    System.setErr(this.out);
                }
                catch (IOException iOException) {
                    msg = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    System.out.println(msg);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    msg = "You must specify a log file when using the -log argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.equals("-buildfile") || arg.equals("-file") || arg.equals("-f")) {
                try {
                    this.buildFile = new File(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    msg = "You must specify a buildfile when using the -buildfile argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.equals("-listener")) {
                try {
                    this.listeners.addElement(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    msg = "You must specify a classname when using the -listener argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.startsWith("-D")) {
                String name = arg.substring(2, arg.length());
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq > 0) {
                    value = name.substring(posEq + 1);
                    name = name.substring(0, posEq);
                } else if (i < args.length - 1) {
                    value = args[++i];
                }
                ((Hashtable)this.definedProps).put(name, value);
            } else if (arg.equals("-logger")) {
                if (this.loggerClassname != null) {
                    System.out.println("Only one logger class may be specified.");
                    return;
                }
                this.loggerClassname = args[++i];
            } else if (arg.equals("-emacs")) {
                this.emacsMode = true;
            } else if (arg.equals("-projecthelp")) {
                this.projectHelp = true;
            } else if (arg.equals("-find")) {
                searchForThis = i < args.length - 1 ? args[++i] : DEFAULT_BUILD_FILENAME;
            } else {
                if (arg.startsWith("-")) {
                    msg = "Unknown arg: " + arg;
                    System.out.println(msg);
                    Main.printUsage();
                    return;
                }
                this.targets.addElement(arg);
            }
            ++i;
        }
        if (this.buildFile == null) {
            this.buildFile = searchForThis != null ? this.findBuildFile(".", searchForThis) : new File(DEFAULT_BUILD_FILENAME);
        }
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        this.readyToRun = true;
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener(this.createLogger());
        int i = 0;
        while (i < this.listeners.size()) {
            String className = (String)this.listeners.elementAt(i);
            try {
                BuildListener listener = (BuildListener)Class.forName(className).newInstance();
                project.addBuildListener(listener);
            }
            catch (Exception exc) {
                throw new BuildException("Unable to instantiate listener " + className, exc);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private BuildLogger createLogger() {
        BuildLogger logger = null;
        if (this.loggerClassname != null) {
            try {
                logger = (BuildLogger)Class.forName(this.loggerClassname).newInstance();
            }
            catch (ClassCastException classCastException) {
                System.err.println("The specified logger class " + this.loggerClassname + " does not implement the BuildLogger interface");
                throw new RuntimeException();
            }
            catch (Exception e) {
                System.err.println("Unable to instantiate specified logger class " + this.loggerClassname + " : " + e.getClass().getName());
                throw new RuntimeException();
            }
        } else {
            logger = new DefaultLogger();
        }
        logger.setMessageOutputLevel(this.msgOutputLevel);
        logger.setOutputPrintStream(this.out);
        logger.setErrorPrintStream(this.err);
        logger.setEmacsMode(this.emacsMode);
        return logger;
    }

    private File findBuildFile(String start, String suffix) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            System.out.println("Searching for " + suffix + " ...");
        }
        File parent = new File(new File(start).getAbsolutePath());
        File file = new File(parent, suffix);
        while (!file.exists()) {
            if ((parent = this.getParentFile(parent)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file = new File(parent, suffix);
        }
        return file;
    }

    private static int findTargetPosition(Vector names, String name) {
        int res = names.size();
        int i = 0;
        while (i < names.size() && res == names.size()) {
            if (name.compareTo((String)names.elementAt(i)) < 0) {
                res = i;
            }
            ++i;
        }
        return res;
    }

    private File getParentFile(File file) {
        String filename = file.getAbsolutePath();
        file = new File(filename);
        if ((filename = file.getParent()) != null && this.msgOutputLevel >= 3) {
            System.out.println("Searching in " + filename);
        }
        return filename == null ? null : new File(filename);
    }

    public static void main(String[] args) {
        Main m = null;
        try {
            m = new Main(args);
        }
        catch (Throwable exc) {
            Main.printMessage(exc);
            System.exit(1);
        }
        try {
            m.runBuild();
            System.exit(0);
        }
        catch (BuildException be) {
            if (m.err != System.err) {
                Main.printMessage(be);
            }
            System.exit(1);
        }
        catch (Throwable exc) {
            Main.printMessage(exc);
            System.exit(1);
        }
    }

    private static void printMessage(Throwable t) {
        String message = t.getMessage();
        if (message != null) {
            System.err.println(message);
        }
    }

    private static void printTargets(Vector names, Vector descriptions, String heading, int maxlen) {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() < maxlen) {
            spaces = String.valueOf(spaces) + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(String.valueOf(heading) + lSep + lSep);
        int i = 0;
        while (i < names.size()) {
            msg.append(" ");
            msg.append(names.elementAt(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - ((String)names.elementAt(i)).length() + 2));
                msg.append(descriptions.elementAt(i));
            }
            msg.append(lSep);
            ++i;
        }
        System.out.println(msg.toString());
    }

    private static void printTargets(Project project) {
        int maxLength = 0;
        Enumeration ptargets = project.getTargets().elements();
        Vector<String> topNames = new Vector<String>();
        Vector<String> topDescriptions = new Vector<String>();
        Vector<String> subNames = new Vector<String>();
        while (ptargets.hasMoreElements()) {
            int pos;
            Target currentTarget = (Target)ptargets.nextElement();
            String targetName = currentTarget.getName();
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                pos = Main.findTargetPosition(subNames, targetName);
                subNames.insertElementAt(targetName, pos);
                continue;
            }
            pos = Main.findTargetPosition(topNames, targetName);
            topNames.insertElementAt(targetName, pos);
            topDescriptions.insertElementAt(targetDescription, pos);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        Main.printTargets(topNames, topDescriptions, "Main targets:", maxLength);
        Main.printTargets(subNames, null, "Subtargets:", 0);
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("ant [options] [target [target2 [target3] ...]]" + lSep);
        msg.append("Options: " + lSep);
        msg.append("  -help                  print this message" + lSep);
        msg.append("  -projecthelp           print project help information" + lSep);
        msg.append("  -version               print the version information and exit" + lSep);
        msg.append("  -quiet                 be extra quiet" + lSep);
        msg.append("  -verbose               be extra verbose" + lSep);
        msg.append("  -debug                 print debugging information" + lSep);
        msg.append("  -emacs                 produce logging information without adornments" + lSep);
        msg.append("  -logfile <file>        use given file for log" + lSep);
        msg.append("  -logger <classname>    the class which is to perform logging" + lSep);
        msg.append("  -listener <classname>  add an instance of class as a project listener" + lSep);
        msg.append("  -buildfile <file>      use given buildfile" + lSep);
        msg.append("  -D<property>=<value>   use value for given property" + lSep);
        msg.append("  -find <file>           search for buildfile towards the root of the file" + lSep);
        msg.append("                         system and use it" + lSep);
        System.out.println(msg.toString());
    }

    private static void printVersion() {
        try {
            Properties props = new Properties();
            InputStream in = (class$org$apache$tools$ant$Main != null ? class$org$apache$tools$ant$Main : (class$org$apache$tools$ant$Main = Main.class$("org.apache.tools.ant.Main"))).getResourceAsStream("/org/apache/tools/ant/version.txt");
            props.load(in);
            in.close();
            String lSep = System.getProperty("line.separator");
            StringBuffer msg = new StringBuffer();
            msg.append("Ant version ");
            msg.append(props.getProperty("VERSION"));
            msg.append(" compiled on ");
            msg.append(props.getProperty("DATE"));
            msg.append(lSep);
            System.out.println(msg.toString());
        }
        catch (IOException ioe) {
            System.err.println("Could not load the version information.");
            System.err.println(ioe.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Could not load the version information.");
        }
    }

    private void runBuild() throws BuildException {
        if (!this.readyToRun) {
            return;
        }
        if (this.msgOutputLevel >= 2) {
            System.out.println("Buildfile: " + this.buildFile);
        }
        Project project = new Project();
        Throwable error = null;
        try {
            try {
                this.addBuildListeners(project);
                project.fireBuildStarted();
                project.init();
                Enumeration e = ((Hashtable)this.definedProps).keys();
                while (e.hasMoreElements()) {
                    String arg = (String)e.nextElement();
                    String value = (String)((Hashtable)this.definedProps).get(arg);
                    project.setUserProperty(arg, value);
                }
                project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                try {
                    Class.forName("javax.xml.parsers.SAXParserFactory");
                    ProjectHelper.configureProject(project, this.buildFile);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new BuildException("No JAXP compliant XML parser found. See http://java.sun.com/xml for the\nreference implementation.", ncdfe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new BuildException("No JAXP compliant XML parser found. See http://java.sun.com/xml for the\nreference implementation.", cnfe);
                }
                catch (NullPointerException npe) {
                    throw new BuildException("No JAXP compliant XML parser found. See http://java.sun.com/xml for the\nreference implementation.", npe);
                }
                if (this.targets.size() == 0) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                if (this.projectHelp) {
                    Main.printTargets(project);
                } else {
                    project.executeTargets(this.targets);
                }
            }
            catch (RuntimeException exc) {
                error = exc;
                throw exc;
            }
            catch (Error err) {
                error = err;
                throw err;
            }
            Object var4_11 = null;
            project.fireBuildFinished(error);
        }
        catch (Throwable throwable) {
            Object var4_12 = null;
            project.fireBuildFinished(error);
            throw throwable;
        }
    }
}

