Migrating to version 3.0.0
==========================

Since version `3.0.0` we have introduced a couple of non-backwards compatible changes. This guide 
helps you migrate from previous versions (< `3.0.0`).

# Migration steps

## Upgrade Elixir and OTP

* Ensure you are using at least `Elixir 1.8`
* Ensure you are using at least `OTP 21.0`

## Adjust consumed Telemetry events

If you have been using `Telemetry` events dispatched by `GenRMQ`, introduced in version `2.4.0`, here is the list of changes:

* Event `[:gen_rmq, :consumer, :message, :error]` replaced by `[:gen_rmq, :consumer, :message, :exception]`
* Event `[:gen_rmq, :publisher, :message, :error]` removed. Event `[:gen_rmq, :publisher, :message, :stop]` dispatched instead with `metadata` containing error details
* Measurment `time` containing monothonic time, replaced by `system_time` containing system time. Check [System][system] documentation for more details regarding differences

Feel free to visit detailed `Telemetry` events documentation for [publisher][publisher_telemetry_events]
and [consumer][consumer_telemetry_events] behaviours. If you have not started to use them, no required migration steps are necessary.

## Implement new consumer callback -  `handle_error/2`

We have re-designed how the consumers are handling concurrency. We have replaced non-supervised processes (started via `spawn`)
with [supervised tasks](https://hexdocs.pm/elixir/Task.Supervisor.html). This gives better control in case of errors but also requires
a couple of extra configuration steps:

* Implement consumer `handle_error/2` callback which is invoked when an error or timeout is encountered while executing `handle_message` callback.

  To reject the message that caused the task to fail you can do something like so:

  ~~~elixir
  def handle_error(message, reason) do
    # Do something with message and reject it
    Logger.warn("Failed to process message: #\{inspect(message)}")

    GenRMQ.Consumer.reject(message)
  end
  ~~~

* (optional) Specify `handle_message_timeout` consumer configuration option if default value is too low for your usecase.

  This attribute defines how long the `handle_message` callback will execute within a supervised task.
  The value is in milliseconds and the default is `5000` milliseconds.

* (optional) Specify `terminate_timeout` consumer configuration options if default value is too low for your usecase.

  This attribute defines how long the consumer will wait for in-flight tasks to complete before terminating the consumer process.
  The value is in milliseconds and the default is `5000` milliseconds.

[system]: https://hexdocs.pm/elixir/System.html#module-time
[consumer_telemetry_events]: https://github.com/meltwater/gen_rmq/blob/master/lib/gen_rmq/consumer/telemetry.ex
[publisher_telemetry_events]: https://github.com/meltwater/gen_rmq/blob/master/lib/gen_rmq/publisher/telemetry.ex
